---
generated_at: 2026-01-20 10:45:00
metrics:
  claims_total: 38
  claims_with_evidence: 37
  claims_without_evidence: 1
confidence_derived: 0.97
---

# 根拠レポート: BitArray機能設計書

## 1. 概要

本レポートは、No.23 BitArray機能設計書に記載された内容の根拠を示すものである。

## 2. 主張と根拠の対応表

### 2.1 機能概要セクション

| No | 主張 | 根拠ファイル | 行番号 | 根拠内容 |
|----|------|--------------|--------|----------|
| 1 | BitArrayはビット値のコンパクトな配列を管理 | BitArray.cls | 38-39 | ドキュメントコメントで「Manages a compact array of bit values. Each bit represents a boolean」と記載 |
| 2 | True = 1、False = 0 | BitArray.cls | 39 | 「True = 1, and False = 0」と記載 |
| 3 | デフォルトサイズは32ビット | BitArray.cls | 41 | 「The default BitArray size is 32 bits」と記載 |
| 4 | ICollectionインターフェースを実装 | BitArray.cls | 48 | `Implements ICollection` の宣言 |
| 5 | IEnumerableインターフェースを実装 | BitArray.cls | 47 | `Implements IEnumerable` の宣言 |
| 6 | ICloneableインターフェースを実装 | BitArray.cls | 49 | `Implements ICloneable` の宣言 |
| 7 | IVersionableインターフェースを実装 | BitArray.cls | 50 | `Implements IVersionable` の宣言 |

### 2.2 データ構造セクション

| No | 主張 | 根拠ファイル | 行番号 | 根拠内容 |
|----|------|--------------|--------|----------|
| 8 | mBits配列の存在 | BitArray.cls | 60 | `Private mBits() As Long` |
| 9 | mLength変数の存在 | BitArray.cls | 61 | `Private mLength As Long` |
| 10 | mUBound変数の存在 | BitArray.cls | 62 | `Private mUBound As Long` |
| 11 | mVersion変数の存在 | BitArray.cls | 63 | `Private mVersion As Long` |
| 12 | BitsPerLong定数の値（32） | BitArray.cls | 57 | `Private Const BitsPerLong As Long = 32` |
| 13 | BitsPerByte定数の値（8） | BitArray.cls | 58 | `Private Const BitsPerByte As Long = 8` |

### 2.3 提供機能セクション

| No | 主張 | 根拠ファイル | 行番号 | 根拠内容 |
|----|------|--------------|--------|----------|
| 14 | Itemプロパティの存在 | BitArray.cls | 205-216, 225-242 | `Public Property Get Item` と `Public Property Let Item` |
| 15 | Lengthプロパティの存在 | BitArray.cls | 249-252, 261-274 | `Public Property Get Length` と `Public Property Let Length` |
| 16 | Countプロパティの存在 | BitArray.cls | 150-153 | `Public Property Get Count() As Long` |
| 17 | AndBitsメソッドの存在 | BitArray.cls | 74-84 | `Public Function AndBits(ByVal Bits As BitArray) As BitArray` |
| 18 | OrBitsメソッドの存在 | BitArray.cls | 312-323 | `Public Function OrBits(ByVal Bits As BitArray) As BitArray` |
| 19 | XorBitsメソッドの存在 | BitArray.cls | 360-370 | `Public Function XorBits(ByVal Bits As BitArray) As BitArray` |
| 20 | NotBitsメソッドの存在 | BitArray.cls | 292-303 | `Public Function NotBits() As BitArray` |
| 21 | SetAllメソッドの存在 | BitArray.cls | 330-340 | `Public Sub SetAll(ByVal Value As Boolean)` |
| 22 | Cloneメソッドの存在 | BitArray.cls | 91-95 | `Public Function Clone() As BitArray` |
| 23 | CopyToメソッドの存在 | BitArray.cls | 107-143 | `Public Sub CopyTo(ByRef Arr As Variant, ByVal Index As Long)` |

### 2.4 内部処理セクション

| No | 主張 | 根拠ファイル | 行番号 | 根拠内容 |
|----|------|--------------|--------|----------|
| 24 | EnsureInitedの処理内容 | BitArray.cls | 446-451 | `ReDim mBits(0)` と `mLength = 32` |
| 25 | GetBitIndexの処理内容 | BitArray.cls | 483-486 | `GetBitIndex = Index \ BitsPerLong` と `Bit = Powers(...)` |
| 26 | MaskOffLastElementの存在 | BitArray.cls | 453-467 | `Private Sub MaskOffLastElement` |

### 2.5 アルゴリズムセクション

| No | 主張 | 根拠ファイル | 行番号 | 根拠内容 |
|----|------|--------------|--------|----------|
| 27 | AND演算でループ処理 | BitArray.cls | 374-377 | `Bits(i) = Bits(i) And mBits(i)` |
| 28 | OR演算でループ処理 | BitArray.cls | 382-385 | `Bits(i) = Bits(i) Or mBits(i)` |
| 29 | NOT演算でループ処理 | BitArray.cls | 297-299 | `mBits(i) = Not mBits(i)` |
| 30 | XOR演算でループ処理 | BitArray.cls | 390-393 | `Bits(i) = Bits(i) Xor mBits(i)` |

### 2.6 CopyTo処理セクション

| No | 主張 | 根拠ファイル | 行番号 | 根拠内容 |
|----|------|--------------|--------|----------|
| 31 | Long配列へのコピー処理 | BitArray.cls | 115-117 | `Case vbLongArray` と `CorArray.CopyEx` |
| 32 | Byte配列へのコピー処理 | BitArray.cls | 119-124 | `Case vbByteArray` と `Buffer.BlockCopy` |
| 33 | Boolean配列へのコピー処理 | BitArray.cls | 126-138 | `Case vbBooleanArray` と個別ループコピー |

### 2.7 関連コンポーネントセクション

| No | 主張 | 根拠ファイル | 行番号 | 根拠内容 |
|----|------|--------------|--------|----------|
| 34 | BitArrayEnumeratorの使用 | BitArray.cls | 174-176 | `Dim Ret As New BitArrayEnumerator` |
| 35 | CorArray.CopyExの使用 | BitArray.cls | 116 | `CorArray.CopyEx mBits, 0, Arr, Index` |
| 36 | Buffer.BlockCopyの使用 | BitArray.cls | 123 | `Buffer.BlockCopy mBits, 0, Arr, Index - LBound(Arr)` |

### 2.8 シリアライゼーションセクション

| No | 主張 | 根拠ファイル | 行番号 | 根拠内容 |
|----|------|--------------|--------|----------|
| 37 | PropertyBagによるシリアライゼーション | BitArray.cls | 492-516 | `Class_ReadProperties`と`Class_WriteProperties`の実装 |

## 3. 根拠なしの主張

| No | 主張 | 理由 |
|----|------|------|
| 1 | 変更履歴の日付（2012年） | ソースファイルのコピーライト年から推定。具体的なコミット履歴は未確認 |

## 4. 信頼度算出

- 主張総数: 38
- 根拠あり: 37
- 根拠なし: 1
- 信頼度: 37 / 38 = 0.97 (97%)

## 5. 備考

- 本機能設計書はソースコードの静的解析に基づいて作成された
- 行番号はBitArray.cls (VBCorLib v3.0相当) を基準としている
- Powers配列の実装は別モジュール（Powers.bas）にあり、本レポートでは参照していない
