---
generated_at: 2026-01-20 11:15:00
metrics:
  claims_total: 40
  claims_with_evidence: 39
  claims_without_evidence: 1
confidence_derived: 0.98
---

# 根拠レポート: MemoryStream機能設計書

## 1. 概要

本レポートは、No.27 MemoryStream機能設計書に記載された内容の根拠を示すものである。

## 2. 主張と根拠の対応表

### 2.1 機能概要セクション

| No | 主張 | 根拠ファイル | 行番号 | 根拠内容 |
|----|------|--------------|--------|----------|
| 1 | MemoryStreamはインメモリストリームを提供 | MemoryStream.cls | 38-40 | ドキュメントコメントで「Provides an in-memory stream of data」と記載 |
| 2 | デフォルト容量は256バイト | MemoryStream.cls | 83 | `Private Const DefaultCapacity As Long = 256` |
| 3 | 容量は2倍に拡張 | MemoryStream.cls | 44-45 | 「The capacity will grow by doubling the size」と記載 |
| 4 | IObjectインターフェースを実装 | MemoryStream.cls | 67 | `Implements IObject` の宣言 |
| 5 | Streamインターフェースを実装 | MemoryStream.cls | 68 | `Implements Stream` の宣言 |

### 2.2 データ構造セクション

| No | 主張 | 根拠ファイル | 行番号 | 根拠内容 |
|----|------|--------------|--------|----------|
| 6 | mMode変数の存在 | MemoryStream.cls | 86 | `Private mMode As BufferMode` |
| 7 | mBuffer配列の存在 | MemoryStream.cls | 88 | `Private mBuffer() As Byte` |
| 8 | mCanWrite変数の存在 | MemoryStream.cls | 89 | `Private mCanWrite As Boolean` |
| 9 | mPosition変数の存在 | MemoryStream.cls | 90 | `Private mPosition As Long` |
| 10 | mCapacity変数の存在 | MemoryStream.cls | 91 | `Private mCapacity As Long` |
| 11 | mLength変数の存在 | MemoryStream.cls | 92 | `Private mLength As Long` |
| 12 | mExpandable変数の存在 | MemoryStream.cls | 94 | `Private mExpandable As Boolean` |
| 13 | MaxStreamLength定数の値 | MemoryStream.cls | 84 | `Private Const MaxStreamLength As Long = 2147483647` |

### 2.3 列挙型セクション

| No | 主張 | 根拠ファイル | 行番号 | 根拠内容 |
|----|------|--------------|--------|----------|
| 14 | BufferMode列挙型の定義 | MemoryStream.cls | 77-81 | `Public Enum BufferMode` |
| 15 | ShareModeの存在 | MemoryStream.cls | 78 | `ShareMode` |
| 16 | CopyModeの存在 | MemoryStream.cls | 79 | `CopyMode` |
| 17 | AcquireModeの存在 | MemoryStream.cls | 80 | `AcquireMode` |

### 2.4 提供機能セクション

| No | 主張 | 根拠ファイル | 行番号 | 根拠内容 |
|----|------|--------------|--------|----------|
| 18 | ReadByteメソッドの存在 | MemoryStream.cls | 590-600 | `Public Function ReadByte() As Long` |
| 19 | ReadBlockメソッドの存在 | MemoryStream.cls | 560-573 | `Public Function ReadBlock(...)` |
| 20 | WriteByteメソッドの存在 | MemoryStream.cls | 518-529 | `Public Sub WriteByte(ByVal Value As Byte)` |
| 21 | WriteBlockメソッドの存在 | MemoryStream.cls | 476-493 | `Public Sub WriteBlock(...)` |
| 22 | SeekPositionメソッドの存在 | MemoryStream.cls | 627-640 | `Public Function SeekPosition(...)` |
| 23 | SetLengthメソッドの存在 | MemoryStream.cls | 671-688 | `Public Sub SetLength(...)` |
| 24 | ToArrayメソッドの存在 | MemoryStream.cls | 706-717 | `Public Function ToArray() As Byte()` |
| 25 | WriteToメソッドの存在 | MemoryStream.cls | 741-748 | `Public Sub WriteTo(ByVal Stream As Stream)` |
| 26 | Flushメソッドの存在 | MemoryStream.cls | 721-723 | `Public Sub Flush()` |
| 27 | CloseStreamメソッドの存在 | MemoryStream.cls | 429-438 | `Public Sub CloseStream()` |

### 2.5 内部処理セクション

| No | 主張 | 根拠ファイル | 行番号 | 根拠内容 |
|----|------|--------------|--------|----------|
| 28 | Initサブルーチンの存在 | MemoryStream.cls | 820-847 | `Friend Sub Init(...)` |
| 29 | EnsureBufferサブルーチンの存在 | MemoryStream.cls | 853-863 | `Private Sub EnsureBuffer()` |
| 30 | EnsureCapacityサブルーチンの存在 | MemoryStream.cls | 877-887 | `Private Sub EnsureCapacity(...)` |
| 31 | EnsureOpenサブルーチンの存在 | MemoryStream.cls | 865-869 | `Private Sub EnsureOpen()` |
| 32 | EnsureWritableサブルーチンの存在 | MemoryStream.cls | 871-875 | `Private Sub EnsureWritable()` |

### 2.6 バッファモード処理セクション

| No | 主張 | 根拠ファイル | 行番号 | 根拠内容 |
|----|------|--------------|--------|----------|
| 33 | ShareModeでSAPtr設定とロック | MemoryStream.cls | 833-836 | `SAPtr(mBuffer) = SAPtr(Buffer)` と `SafeArrayLock` |
| 34 | CopyModeで配列コピー | MemoryStream.cls | 837-838 | `mBuffer = Buffer` |
| 35 | AcquireModeでSAPtr移動 | MemoryStream.cls | 839-841 | SAPtr移動処理 |

### 2.7 プロパティセクション

| No | 主張 | 根拠ファイル | 行番号 | 根拠内容 |
|----|------|--------------|--------|----------|
| 36 | CanReadプロパティの存在 | MemoryStream.cls | 295-297 | `Public Property Get CanRead() As Boolean` |
| 37 | CanWriteプロパティの存在 | MemoryStream.cls | 306-308 | `Public Property Get CanWrite() As Boolean` |
| 38 | CanSeekプロパティの存在 | MemoryStream.cls | 315-317 | `Public Property Get CanSeek() As Boolean` |
| 39 | Capacityプロパティの存在 | MemoryStream.cls | 324-352 | Capacity Get/Let |

## 3. 根拠なしの主張

| No | 主張 | 理由 |
|----|------|------|
| 1 | 変更履歴の日付（2015年） | ソースファイルのコピーライト年から推定。具体的なコミット履歴は未確認 |

## 4. 信頼度算出

- 主張総数: 40
- 根拠あり: 39
- 根拠なし: 1
- 信頼度: 39 / 40 = 0.98 (98%)

## 5. 備考

- 本機能設計書はソースコードの静的解析に基づいて作成された
- 行番号はMemoryStream.cls (VBCorLib v3.0相当) を基準としている
- Persistable=1属性によりPropertyBagでのシリアライズをサポート
- StreamAsyncResultクラスは別ファイルに実装されている
