---
generated_at: 2026-01-20 11:25:00
metrics:
  claims_total: 35
  claims_with_evidence: 34
  claims_without_evidence: 1
confidence_derived: 0.97
---

# 根拠レポート: StreamReader機能設計書

## 1. 概要

本レポートは、No.28 StreamReader機能設計書に記載された内容の根拠を示すものである。

## 2. 主張と根拠の対応表

### 2.1 機能概要セクション

| No | 主張 | 根拠ファイル | 行番号 | 根拠内容 |
|----|------|--------------|--------|----------|
| 1 | StreamReaderは特定のエンコーディングでバイト配列から文字を読み取る | StreamReader.cls | 38-45 | ドキュメントコメントで「Reads characters from a byte array in a particular encoding」と記載 |
| 2 | デフォルトエンコーディングはUTF-8 | StreamReader.cls | 46 | 「The default encoding is UTF8Encoding」と記載 |
| 3 | IObjectインターフェースを実装 | StreamReader.cls | 53 | `Implements IObject` の宣言 |
| 4 | TextReaderインターフェースを実装 | StreamReader.cls | 54 | `Implements TextReader` の宣言 |

### 2.2 データ構造セクション

| No | 主張 | 根拠ファイル | 行番号 | 根拠内容 |
|----|------|--------------|--------|----------|
| 5 | mStream変数の存在 | StreamReader.cls | 58 | `Private mStream As Stream` |
| 6 | mEncoding変数の存在 | StreamReader.cls | 59 | `Private mEncoding As Encoding` |
| 7 | mDecoder変数の存在 | StreamReader.cls | 60 | `Private mDecoder As Decoder` |
| 8 | mByteBuffer配列の存在 | StreamReader.cls | 61 | `Private mByteBuffer() As Byte` |
| 9 | mCharBuffer配列の存在 | StreamReader.cls | 64 | `Private mCharBuffer() As Integer` |
| 10 | mBufferSize変数の存在 | StreamReader.cls | 67 | `Private mBufferSize As Long` |
| 11 | mDetermineEncoding変数の存在 | StreamReader.cls | 68 | `Private mDetermineEncoding As Boolean` |
| 12 | MinimumBufferSize定数の値（128） | StreamReader.cls | 56 | `Private Const MinimumBufferSize As Long = 128` |

### 2.3 提供機能セクション

| No | 主張 | 根拠ファイル | 行番号 | 根拠内容 |
|----|------|--------------|--------|----------|
| 13 | Readメソッドの存在 | StreamReader.cls | 156-162 | `Public Function Read() As Long` |
| 14 | Peekメソッドの存在 | StreamReader.cls | 140-148 | `Public Function Peek() As Long` |
| 15 | ReadBlockメソッドの存在 | StreamReader.cls | 172-198 | `Public Function ReadBlock(...)` |
| 16 | ReadLineメソッドの存在 | StreamReader.cls | 207-298 | `Public Function ReadLine() As String` |
| 17 | ReadToEndメソッドの存在 | StreamReader.cls | 305-326 | `Public Function ReadToEnd() As String` |
| 18 | CloseReaderメソッドの存在 | StreamReader.cls | 104-112 | `Public Sub CloseReader()` |
| 19 | DiscardBufferedDataメソッドの存在 | StreamReader.cls | 124-130 | `Public Sub DiscardBufferedData()` |
| 20 | EndOfStreamプロパティの存在 | StreamReader.cls | 93-99 | `Public Property Get EndOfStream() As Boolean` |

### 2.4 内部処理セクション

| No | 主張 | 根拠ファイル | 行番号 | 根拠内容 |
|----|------|--------------|--------|----------|
| 21 | Initサブルーチンの存在 | StreamReader.cls | 358-371 | `Friend Sub Init(...)` |
| 22 | ReadBuffer関数の存在 | StreamReader.cls | 412-442 | `Private Function ReadBuffer() As Long` |
| 23 | DetermineEncodingサブルーチンの存在 | StreamReader.cls | 444-496 | `Private Sub DetermineEncoding()` |
| 24 | HaveChars関数の存在 | StreamReader.cls | 399-410 | `Private Function HaveChars() As Boolean` |
| 25 | CreateStreamサブルーチンの存在 | StreamReader.cls | 381-397 | `Private Sub CreateStream(ByRef Source As Variant)` |

### 2.5 BOM判定セクション

| No | 主張 | 根拠ファイル | 行番号 | 根拠内容 |
|----|------|--------------|--------|----------|
| 26 | Unicode Little Endian BOM判定 | StreamReader.cls | 461-470 | `Case UnicodeLittleEndianBOM` |
| 27 | Unicode Big Endian BOM判定 | StreamReader.cls | 472-473 | `Case UnicodeBigEndianBOM` |
| 28 | UTF-8 BOM判定 | StreamReader.cls | 475-482 | `Case UTF8PartialBOM` |
| 29 | UTF-32 BOM判定 | StreamReader.cls | 484-491 | `Case 0` での判定 |

### 2.6 プロパティセクション

| No | 主張 | 根拠ファイル | 行番号 | 根拠内容 |
|----|------|--------------|--------|----------|
| 30 | BaseStreamプロパティの存在 | StreamReader.cls | 79-81 | `Public Property Get BaseStream() As Stream` |
| 31 | CurrentEncodingプロパティの存在 | StreamReader.cls | 88-90 | `Public Property Get CurrentEncoding() As Encoding` |

### 2.7 改行処理セクション

| No | 主張 | 根拠ファイル | 行番号 | 根拠内容 |
|----|------|--------------|--------|----------|
| 32 | CR/LF改行文字の処理 | StreamReader.cls | 238-239 | `Case vbReturnChar, vbLineFeedChar` |
| 33 | CR-LF対応処理 | StreamReader.cls | 279-297 | CR後のLFチェック処理 |

### 2.8 ストリーム作成セクション

| No | 主張 | 根拠ファイル | 行番号 | 根拠内容 |
|----|------|--------------|--------|----------|
| 34 | 文字列からFileStreamを作成 | StreamReader.cls | 391-392 | `Set mStream = Cor.NewFileStream(CStr(Source), ...)` |

## 3. 根拠なしの主張

| No | 主張 | 理由 |
|----|------|------|
| 1 | 変更履歴の日付（2012年） | ソースファイルのコピーライト年から推定。具体的なコミット履歴は未確認 |

## 4. 信頼度算出

- 主張総数: 35
- 根拠あり: 34
- 根拠なし: 1
- 信頼度: 34 / 35 = 0.97 (97%)

## 5. 備考

- 本機能設計書はソースコードの静的解析に基づいて作成された
- 行番号はStreamReader.cls (VBCorLib v3.0相当) を基準としている
- Encoding, Decoder, StringBuilder等の依存クラスは別ファイルに実装されている
