---
generated_at: 2026-01-20 11:35:00
metrics:
  claims_total: 38
  claims_with_evidence: 37
  claims_without_evidence: 1
confidence_derived: 0.97
---

# 根拠レポート: StreamWriter機能設計書

## 1. 概要

本レポートは、No.29 StreamWriter機能設計書に記載された内容の根拠を示すものである。

## 2. 主張と根拠の対応表

### 2.1 機能概要セクション

| No | 主張 | 根拠ファイル | 行番号 | 根拠内容 |
|----|------|--------------|--------|----------|
| 1 | StreamWriterは特定のエンコーディングでバイトストリームに文字を書き込む | StreamWriter.cls | 38-39 | ドキュメントコメントで「Writes characters to a byte stream using the specific encoding」と記載 |
| 2 | デフォルトエンコーディングはUTF-8（BOMなし） | StreamWriter.cls | 41-44 | 「StreamWriter defaults to using an instance of UTF8Encoding ... without a byte order mark (BOM)」と記載 |
| 3 | IObjectインターフェースを実装 | StreamWriter.cls | 51 | `Implements IObject` の宣言 |
| 4 | TextWriterインターフェースを実装 | StreamWriter.cls | 52 | `Implements TextWriter` の宣言 |

### 2.2 データ構造セクション

| No | 主張 | 根拠ファイル | 行番号 | 根拠内容 |
|----|------|--------------|--------|----------|
| 5 | mStream変数の存在 | StreamWriter.cls | 56 | `Private mStream As Stream` |
| 6 | mAutoFlush変数の存在 | StreamWriter.cls | 57 | `Private mAutoFlush As Boolean` |
| 7 | mEncoding変数の存在 | StreamWriter.cls | 58 | `Private mEncoding As Encoding` |
| 8 | mEncoder変数の存在 | StreamWriter.cls | 59 | `Private mEncoder As Encoder` |
| 9 | mNewLine変数の存在 | StreamWriter.cls | 60 | `Private mNewLine As String` |
| 10 | mCharBuffer配列の存在 | StreamWriter.cls | 61 | `Private mCharBuffer() As Integer` |
| 11 | mByteBuffer配列の存在 | StreamWriter.cls | 62 | `Private mByteBuffer() As Byte` |
| 12 | mBufferSize変数の存在 | StreamWriter.cls | 63 | `Private mBufferSize As Long` |
| 13 | mPosition変数の存在 | StreamWriter.cls | 64 | `Private mPosition As Long` |
| 14 | mIsOpen変数の存在 | StreamWriter.cls | 65 | `Private mIsOpen As Boolean` |
| 15 | mPreambleWritten変数の存在 | StreamWriter.cls | 66 | `Private mPreambleWritten As Boolean` |
| 16 | mLeaveOpen変数の存在 | StreamWriter.cls | 67 | `Private mLeaveOpen As Boolean` |
| 17 | MIN_BUFFERSIZE定数の値（128） | StreamWriter.cls | 54 | `Private Const MIN_BUFFERSIZE As Long = 128` |

### 2.3 提供機能セクション

| No | 主張 | 根拠ファイル | 行番号 | 根拠内容 |
|----|------|--------------|--------|----------|
| 18 | WriteValueメソッドの存在 | StreamWriter.cls | 196-210 | `Public Sub WriteValue(...)` |
| 19 | WriteCharsメソッドの存在 | StreamWriter.cls | 230-244 | `Public Sub WriteChars(...)` |
| 20 | WriteLineメソッドの存在 | StreamWriter.cls | 272-286 | `Public Sub WriteLine(...)` |
| 21 | WriteLineCharsメソッドの存在 | StreamWriter.cls | 303-312 | `Public Sub WriteLineChars(...)` |
| 22 | Flushメソッドの存在 | StreamWriter.cls | 166-169 | `Public Sub Flush()` |
| 23 | CloseWriterメソッドの存在 | StreamWriter.cls | 144-161 | `Public Sub CloseWriter()` |
| 24 | AutoFlushプロパティの存在 | StreamWriter.cls | 75-90 | AutoFlush Get/Let |
| 25 | NewLineプロパティの存在 | StreamWriter.cls | 124-139 | NewLine Get/Let |

### 2.4 内部処理セクション

| No | 主張 | 根拠ファイル | 行番号 | 根拠内容 |
|----|------|--------------|--------|----------|
| 26 | Initサブルーチンの存在 | StreamWriter.cls | 350-388 | `Friend Sub Init(...)` |
| 27 | WriteCoreサブルーチンの存在 | StreamWriter.cls | 429-461 | `Private Sub WriteCore(...)` |
| 28 | InternalFlushサブルーチンの存在 | StreamWriter.cls | 483-497 | `Private Sub InternalFlush(...)` |
| 29 | WritePreambleサブルーチンの存在 | StreamWriter.cls | 469-481 | `Private Sub WritePreamble()` |
| 30 | VerifyIsOpenの存在 | StreamWriter.cls | 463-467 | `Private Sub VerifyIsOpen()` |

### 2.5 初期化処理セクション

| No | 主張 | 根拠ファイル | 行番号 | 根拠内容 |
|----|------|--------------|--------|----------|
| 31 | ファイルパスからFileStream作成 | StreamWriter.cls | 367-368 | `Set mStream = Cor.NewFileStream(CStr(Source), Mode, ...)` |
| 32 | Appendモード対応 | StreamWriter.cls | 367 | `Mode = IIfLong(Append, FileMode.Append, FileMode.Create)` |
| 33 | デフォルトエンコーディング設定 | StreamWriter.cls | 380 | `Set mEncoding = IfObject(Encoding, Stream.UTF8NoBOMAndThrows)` |
| 34 | 改行文字列のデフォルト | StreamWriter.cls | 382 | `mNewLine = Environment.NewLine` |

### 2.6 プロパティセクション

| No | 主張 | 根拠ファイル | 行番号 | 根拠内容 |
|----|------|--------------|--------|----------|
| 35 | BaseStreamプロパティの存在 | StreamWriter.cls | 97-99 | `Public Property Get BaseStream() As Stream` |
| 36 | Encodingプロパティの存在 | StreamWriter.cls | 106-108 | `Public Property Get Encoding() As Encoding` |
| 37 | FormatProviderプロパティの存在 | StreamWriter.cls | 115-117 | `Public Property Get FormatProvider() As IFormatProvider` |

## 3. 根拠なしの主張

| No | 主張 | 理由 |
|----|------|------|
| 1 | 変更履歴の日付（2012年） | ソースファイルのコピーライト年から推定。具体的なコミット履歴は未確認 |

## 4. 信頼度算出

- 主張総数: 38
- 根拠あり: 37
- 根拠なし: 1
- 信頼度: 37 / 38 = 0.97 (97%)

## 5. 備考

- 本機能設計書はソースコードの静的解析に基づいて作成された
- 行番号はStreamWriter.cls (VBCorLib v3.0相当) を基準としている
- Encoding, Encoder, StringBuilder等の依存クラスは別ファイルに実装されている
- TextWriterインターフェースの実装により、StreamReaderと対称的なAPI設計となっている
