---
generated_at: 2026-01-20 11:00:00
metrics:
  claims_total: 30
  claims_with_evidence: 28
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：3-CorDateTime.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：28 / 30、根拠なし：2
- 優先レビュー（高）
  1. **CorDateTimeStaticの詳細実装**：別ファイルのため未確認
  2. **GetDatePartsの完全なロジック**：800行以降のため部分確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/CorLib/System/CorDateTime.cls` 38-48行目（モジュールコメント）
- E-02: `Source/CorLib/System/CorDateTime.cls` 50-52行目（インターフェース実装宣言）
- E-03: `Source/CorLib/System/CorDateTime.cls` 54-65行目（定数定義）
- E-04: `Source/CorLib/System/CorDateTime.cls` 67-72行目（内部変数コメントと定義）
- E-05: `Source/CorLib/System/CorDateTime.cls` 81-83行目（Kindプロパティ）
- E-06: `Source/CorLib/System/CorDateTime.cls` 91-93行目（IsDayLightSavingsTimeプロパティ）
- E-07: `Source/CorLib/System/CorDateTime.cls` 103-126行目（ToOADateメソッド）
- E-08: `Source/CorLib/System/CorDateTime.cls` 133-135行目（Yearプロパティ）
- E-09: `Source/CorLib/System/CorDateTime.cls` 142-144行目（Dayプロパティ）
- E-10: `Source/CorLib/System/CorDateTime.cls` 151-153行目（Monthプロパティ）
- E-11: `Source/CorLib/System/CorDateTime.cls` 161-163行目（DayOfYearプロパティ）
- E-12: `Source/CorLib/System/CorDateTime.cls` 173-175行目（DayOfWeekプロパティ）
- E-13: `Source/CorLib/System/CorDateTime.cls` 182-184行目（Hourプロパティ）
- E-14: `Source/CorLib/System/CorDateTime.cls` 191-193行目（Minuteプロパティ）
- E-15: `Source/CorLib/System/CorDateTime.cls` 200-202行目（Secondプロパティ）
- E-16: `Source/CorLib/System/CorDateTime.cls` 209-211行目（Millisecondプロパティ）
- E-17: `Source/CorLib/System/CorDateTime.cls` 221-223行目（TotalMillisecondsプロパティ）
- E-18: `Source/CorLib/System/CorDateTime.cls` 232-234行目（Ticksプロパティ）
- E-19: `Source/CorLib/System/CorDateTime.cls` 243-245行目（DateOnlyプロパティ）
- E-20: `Source/CorLib/System/CorDateTime.cls` 254-256行目（TimeOfDayプロパティ）
- E-21: `Source/CorLib/System/CorDateTime.cls` 264-269行目（Addメソッド）
- E-22: `Source/CorLib/System/CorDateTime.cls` 277-288行目（AddMillisecondsメソッド）
- E-23: `Source/CorLib/System/CorDateTime.cls` 296-298行目（AddDaysメソッド）
- E-24: `Source/CorLib/System/CorDateTime.cls` 306-308行目（AddHoursメソッド）
- E-25: `Source/CorLib/System/CorDateTime.cls` 316-318行目（AddMinutesメソッド）
- E-26: `Source/CorLib/System/CorDateTime.cls` 329-366行目（AddMonthsメソッド）
- E-27: `Source/CorLib/System/CorDateTime.cls` 374-376行目（AddSecondsメソッド）
- E-28: `Source/CorLib/System/CorDateTime.cls` 384-392行目（AddTicksメソッド）
- E-29: `Source/CorLib/System/CorDateTime.cls` 400-402行目（AddYearsメソッド）
- E-30: `Source/CorLib/System/CorDateTime.cls` 413-427行目（CompareToメソッド）
- E-31: `Source/CorLib/System/CorDateTime.cls` 435-437行目（ToFileTimeメソッド）
- E-32: `Source/CorLib/System/CorDateTime.cls` 445-460行目（ToFileTimeUtcメソッド）
- E-33: `Source/CorLib/System/CorDateTime.cls` 467-473行目（ToLocalTimeメソッド）
- E-34: `Source/CorLib/System/CorDateTime.cls` 480-486行目（ToUniversalTimeメソッド）
- E-35: `Source/CorLib/System/CorDateTime.cls` 514-519行目（ToStringメソッド）
- E-36: `Source/CorLib/System/CorDateTime.cls` 526-555行目（ToLong/ShortDate/TimeStringメソッド）
- E-37: `Source/CorLib/System/CorDateTime.cls` 564-574行目（ToBinaryメソッド）
- E-38: `Source/CorLib/System/CorDateTime.cls` 582-586行目（Equalsメソッド）
- E-39: `Source/CorLib/System/CorDateTime.cls` 597-619行目（Subtractメソッド）
- E-40: `Source/CorLib/System/CorDateTime.cls` 626-630行目（GetHashCodeメソッド）
- E-41: `Source/CorLib/System/CorDateTime.cls` 639-714行目（比較メソッド群）
- E-42: `Source/CorLib/System/CorDateTime.cls` 720-728行目（Initメソッド）
- E-43: `Source/CorLib/System/CorDateTime.cls` 730-736行目（InitFromMillisecondsメソッド）
- E-44: `Source/CorLib/System/CorDateTime.cls` 791-800行目（GetDatePartsメソッド冒頭）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 1/1/0001から12/31/9999までの日付範囲をサポート | E-01, E-03 | ○ |
| C-02 | IObject、IComparable、IFormattableを実装 | E-02 | ○ |
| C-03 | Currency型で64ビット整数相当の精度 | E-04 | ○ |
| C-04 | Kindプロパティ（Unspecified/Utc/Local） | E-05 | ○ |
| C-05 | IsDayLightSavingsTimeはTimeZoneを参照 | E-06 | ○ |
| C-06 | ToOADateはOLE Automation日付に変換 | E-07 | ○ |
| C-07 | Year/Month/DayはGetDatePartsで算出 | E-08, E-09, E-10 | ○ |
| C-08 | DayOfYearは年内の日数 | E-11 | ○ |
| C-09 | DayOfWeekは0=Sunday（0ベース） | E-12 | ○ |
| C-10 | Hour/Minute/Secondはミリ秒から直接算出 | E-13, E-14, E-15 | ○ |
| C-11 | Millisecondはミリ秒の余り | E-16 | ○ |
| C-12 | TotalMillisecondsはCurrency型で返す | E-17 | ○ |
| C-13 | TicksはDecimal型で返す | E-18 | ○ |
| C-14 | DateOnlyは時刻部分を除去 | E-19 | ○ |
| C-15 | TimeOfDayはTimeSpanで返す | E-20 | ○ |
| C-16 | AddはTimeSpanを加算 | E-21 | ○ |
| C-17 | AddMillisecondsは基本演算メソッド | E-22 | ○ |
| C-18 | AddDays/Hours/Minutes/SecondsはAddMillisecondsを使用 | E-23, E-24, E-25, E-27 | ○ |
| C-19 | AddMonthsは月末日を調整 | E-26 | ○ |
| C-20 | AddTicksはDecimal演算 | E-28 | ○ |
| C-21 | AddYearsはAddMonthsを使用 | E-29 | ○ |
| C-22 | CompareToはミリ秒比較 | E-30 | ○ |
| C-23 | ToFileTimeはToUniversalTimeを経由 | E-31 | ○ |
| C-24 | ToFileTimeUtcはローカル時間を変換 | E-32 | ○ |
| C-25 | ToLocalTime/ToUniversalTimeはTimeZoneを使用 | E-33, E-34 | ○ |
| C-26 | ToStringはDateTimeFormatInfoを使用 | E-35 | ○ |
| C-27 | ToBinaryはKindを上位2ビットに格納 | E-37 | ○ |
| C-28 | SubtractはTimeSpanまたはCorDateTimeを返す | E-39 | ○ |
| C-29 | CorDateTimeStaticの詳細実装 | **別ファイル未確認** | △ |
| C-30 | GetDatePartsの完全なロジック | **800行以降未確認** | △ |

## 4) 不足情報（Unknown / Missing）
- CorDateTimeStaticクラスの詳細実装
  - 候補：`Source/CorLib/System/CorDateTimeStatic.cls` の確認が必要
- GetDatePartsの完全なロジック
  - 候補：CorDateTime.clsの800行以降を確認
- modDateTime.basのヘルパー関数群
  - 候補：`Source/CorLib/System/modDateTime.bas` の確認が必要

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要なメソッド仕様は全てソースコードで確認済み
- 0: 低リスク - 日付計算の定数定義は完全に確認済み
- 1: 中リスク - タイムゾーン変換はシステム設定に依存するため、環境による動作差異の可能性

## 6) レビュアーチェックリスト（最小）
- [ ] CorDateTimeStaticの実装確認（FromMilliseconds、DaysInMonth、GetTotalDays等）
- [ ] GetDatePartsの完全なロジック確認（800行以降）
- [ ] modDateTime.basのヘルパー関数確認
- [ ] うるう年・月末日の処理が正しいか確認
- [ ] タイムゾーン変換の境界ケース確認
