---
generated_at: 2026-01-20 11:45:00
metrics:
  claims_total: 42
  claims_with_evidence: 41
  claims_without_evidence: 1
confidence_derived: 0.98
---

# 根拠レポート: BinaryReader機能設計書

## 1. 概要

本レポートは、No.30 BinaryReader機能設計書に記載された内容の根拠を示すものである。

## 2. 主張と根拠の対応表

### 2.1 機能概要セクション

| No | 主張 | 根拠ファイル | 行番号 | 根拠内容 |
|----|------|--------------|--------|----------|
| 1 | BinaryReaderはストリームから型付きデータを読み取る | BinaryReader.cls | 38-44 | ドキュメントコメントで「Provides a set of methods to read typed information from a Stream」と記載 |
| 2 | デフォルトエンコーディングはUTF-8 | BinaryReader.cls | 45-46 | 「If no Encoding is specified then the BinaryReader is created using UTF8Encoding」と記載 |
| 3 | IObjectインターフェースを実装 | BinaryReader.cls | 52 | `Implements IObject` の宣言 |

### 2.2 データ構造セクション

| No | 主張 | 根拠ファイル | 行番号 | 根拠内容 |
|----|------|--------------|--------|----------|
| 4 | mStream変数の存在 | BinaryReader.cls | 57 | `Private mStream As Stream` |
| 5 | mLeaveOpen変数の存在 | BinaryReader.cls | 58 | `Private mLeaveOpen As Boolean` |
| 6 | mDecoder変数の存在 | BinaryReader.cls | 59 | `Private mDecoder As Decoder` |
| 7 | mBuffer配列の存在 | BinaryReader.cls | 60 | `Private mBuffer() As Byte` |
| 8 | mSingleChar配列の存在 | BinaryReader.cls | 61 | `Private mSingleChar(0) As Integer` |
| 9 | mCharBytes配列の存在 | BinaryReader.cls | 62 | `Private mCharBytes() As Byte` |
| 10 | mIs2ByteChars変数の存在 | BinaryReader.cls | 63 | `Private mIs2ByteChars As Boolean` |
| 11 | DefaultCapacity定数の値（16） | BinaryReader.cls | 54 | `Private Const DefaultCapacity As Long = 16` |
| 12 | NoChars定数の値（-1） | BinaryReader.cls | 55 | `Private Const NoChars As Long = -1` |

### 2.3 提供機能セクション

| No | 主張 | 根拠ファイル | 行番号 | 根拠内容 |
|----|------|--------------|--------|----------|
| 13 | Readメソッドの存在 | BinaryReader.cls | 102-109 | `Public Function Read(...)` |
| 14 | PeekCharメソッドの存在 | BinaryReader.cls | 133-144 | `Public Function PeekChar() As Long` |
| 15 | ReadByteメソッドの存在 | BinaryReader.cls | 154-157 | `Public Function ReadByte() As Byte` |
| 16 | ReadCharメソッドの存在 | BinaryReader.cls | 169-178 | `Public Function ReadChar() As Integer` |
| 17 | ReadBytesメソッドの存在 | BinaryReader.cls | 190-214 | `Public Function ReadBytes(...)` |
| 18 | ReadCharsメソッドの存在 | BinaryReader.cls | 225-249 | `Public Function ReadChars(...)` |
| 19 | ReadBooleanメソッドの存在 | BinaryReader.cls | 272-274 | `Public Function ReadBoolean() As Boolean` |
| 20 | ReadInt16メソッドの存在 | BinaryReader.cls | 352-355 | `Public Function ReadInt16() As Integer` |
| 21 | ReadInt32メソッドの存在 | BinaryReader.cls | 325-328 | `Public Function ReadInt32() As Long` |
| 22 | ReadInt64メソッドの存在 | BinaryReader.cls | 298-301 | `Public Function ReadInt64() As Int64` |
| 23 | ReadDoubleメソッドの存在 | BinaryReader.cls | 379-382 | `Public Function ReadDouble() As Double` |
| 24 | ReadSingleメソッドの存在 | BinaryReader.cls | 464-467 | `Public Function ReadSingle() As Single` |
| 25 | ReadCurrencyメソッドの存在 | BinaryReader.cls | 437-440 | `Public Function ReadCurrency() As Currency` |
| 26 | ReadDateメソッドの存在 | BinaryReader.cls | 411-413 | `Public Function ReadDate() As Date` |
| 27 | ReadDecimalメソッドの存在 | BinaryReader.cls | 526-529 | `Public Function ReadDecimal() As Variant` |
| 28 | ReadStringメソッドの存在 | BinaryReader.cls | 571-602 | `Public Function ReadString() As String` |
| 29 | CloseReaderメソッドの存在 | BinaryReader.cls | 80-88 | `Public Sub CloseReader()` |

### 2.4 内部処理セクション

| No | 主張 | 根拠ファイル | 行番号 | 根拠内容 |
|----|------|--------------|--------|----------|
| 30 | Initサブルーチンの存在 | BinaryReader.cls | 636-650 | `Friend Sub Init(...)` |
| 31 | FillBufferサブルーチンの存在 | BinaryReader.cls | 660-675 | `Private Sub FillBuffer(...)` |
| 32 | ReadCharBytes関数の存在 | BinaryReader.cls | 739-799 | `Private Function ReadCharBytes(...)` |
| 33 | ReadStringLength関数の存在 | BinaryReader.cls | 801-820 | `Private Function ReadStringLength() As Long` |
| 34 | VerifyIsOpenの存在 | BinaryReader.cls | 677-681 | `Private Sub VerifyIsOpen()` |
| 35 | ReadOneChar関数の存在 | BinaryReader.cls | 683-690 | `Private Function ReadOneChar() As Long` |

### 2.5 7ビットエンコード長セクション

| No | 主張 | 根拠ファイル | 行番号 | 根拠内容 |
|----|------|--------------|--------|----------|
| 36 | 7ビットシフト | BinaryReader.cls | 802 | `Const BitsShiftedAtATime As Long = 7` |
| 37 | 最大35ビット | BinaryReader.cls | 804 | `Const MaxShiftCount As Long = 35` |
| 38 | &H80で継続判定 | BinaryReader.cls | 817 | `Loop While SingleByte And &H80` |

### 2.6 初期化処理セクション

| No | 主張 | 根拠ファイル | 行番号 | 根拠内容 |
|----|------|--------------|--------|----------|
| 39 | UnicodeEncoding判定 | BinaryReader.cls | 646 | `mIs2ByteChars = TypeOf Encoding Is UnicodeEncoding` |
| 40 | デフォルトUTF-8 | BinaryReader.cls | 642-644 | `If Encoding Is Nothing Then Set Encoding = New UTF8Encoding` |

### 2.7 プロパティセクション

| No | 主張 | 根拠ファイル | 行番号 | 根拠内容 |
|----|------|--------------|--------|----------|
| 41 | BaseStreamプロパティの存在 | BinaryReader.cls | 71-73 | `Public Property Get BaseStream() As Stream` |

## 3. 根拠なしの主張

| No | 主張 | 理由 |
|----|------|------|
| 1 | 変更履歴の日付（2014年） | ソースファイルのコピーライト年から推定。具体的なコミット履歴は未確認 |

## 4. 信頼度算出

- 主張総数: 42
- 根拠あり: 41
- 根拠なし: 1
- 信頼度: 41 / 42 = 0.98 (98%)

## 5. 備考

- 本機能設計書はソースコードの静的解析に基づいて作成された
- 行番号はBinaryReader.cls (VBCorLib v3.0相当) を基準としている
- Encoding, Decoder, BitConverter等の依存クラスは別ファイルに実装されている
- BinaryWriterと対になるクラスとして設計されている
- ReadDateは.NETのTicks形式を使用（VBのDouble形式とは異なる）
- ReadDecimalは.NETのバイトレイアウトを使用（VBのDecimalとは異なる）
