---
generated_at: 2026-01-20 16:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：31-BinaryWriter機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. 該当なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/CorLib/System.IO/BinaryWriter.cls` 行1-438（クラス全体）
- E-02: `Source/CorLib/System.IO/BinaryWriter.cls` 行38-47（クラスコメント）
- E-03: `Source/CorLib/System.IO/BinaryWriter.cls` 行236-253（Initコンストラクタ）
- E-04: `Source/CorLib/System.IO/BinaryWriter.cls` 行159-168（WriteValueメソッド）
- E-05: `Source/CorLib/System.IO/BinaryWriter.cls` 行278-307（WriteIntrinsicメソッド）
- E-06: `Source/CorLib/System.IO/BinaryWriter.cls` 行265-276（WriteStringLengthメソッド）
- E-07: `Source/CorLib/System.IO/BinaryWriter.cls` 行358-376（WriteStringメソッド）
- E-08: `Source/CorLib/System.IO/BinaryWriter.cls` 行352-354（WriteDecimalメソッド）
- E-09: `Source/CorLib/System.IO/BinaryWriter.cls` 行50-58（プライベート変数）
- E-10: `Source/Tests/System.IO/BinaryWriterTests.cls`（テストファイル存在確認）
- E-11: `docs/code-to-docs/機能一覧/機能一覧.csv` 行32（機能定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BinaryWriterはストリームにバイナリデータを書き込むクラスである | E-02 | ○ |
| C-02 | 各種プリミティブ型（Boolean、Byte、Integer、Long等）の書き込みをサポート | E-05 | ○ |
| C-03 | 文字列は長さプレフィックス付きで書き込まれる | E-06, E-07 | ○ |
| C-04 | 7ビット可変長整数エンコードが使用される | E-06 | ○ |
| C-05 | Decimalは.NET互換レイアウトに変換される | E-02, E-08 | ○ |
| C-06 | デフォルトエンコーディングはUTF-8である | E-03 | ○ |
| C-07 | 出力ストリームはCanWrite=Trueである必要がある | E-03 | ○ |
| C-08 | 配列はByte配列とInteger配列のみサポート | E-04, E-05 | ○ |
| C-09 | 256バイトのバッファを再利用する | E-09 | ○ |
| C-10 | LeaveOpenオプションでストリームを開いたままにできる | E-03 | ○ |
| C-11 | SeekPositionでストリーム位置を制御できる | E-01 | ○ |
| C-12 | Flushでバッファをフラッシュできる | E-01 | ○ |
| C-13 | CloseWriterでストリームを閉じられる | E-01 | ○ |
| C-14 | WriteCharで単一文字を書き込める | E-01 | ○ |
| C-15 | Int64型の書き込みをサポート | E-05 | ○ |
| C-16 | Date型はミリ秒単位でCurrencyとして書き込まれる | E-01 | ○ |
| C-17 | ストリームが閉じている場合ObjectDisposedExceptionが発生 | E-01 | ○ |
| C-18 | 機能一覧でNo.31として定義されている | E-11 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張にソースコードによる根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] Decimalの.NET互換レイアウト変換が正しく説明されているか確認
- [ ] 7ビット可変長エンコードのアルゴリズムが正確か確認
- [ ] 行番号の参照が実際のソースと一致しているか確認
