---
generated_at: 2026-01-20 16:26:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：35-Directory機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. 該当なし

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/CorLib/System.IO/Directory.cls` 行1-668（クラス全体）
- E-02: `Source/CorLib/System.IO/Directory.cls` 行38-43（クラスコメント）
- E-03: `Source/CorLib/System.IO/Directory.cls` 行61-64（SearchOption列挙体）
- E-04: `Source/CorLib/System.IO/Directory.cls` 行138-147（Existsメソッド）
- E-05: `Source/CorLib/System.IO/Directory.cls` 行74-86（CreateDirectoryメソッド）
- E-06: `Source/CorLib/System.IO/Directory.cls` 行100-121（GetDirectoryPathsToCreate内部メソッド）
- E-07: `Source/CorLib/System.IO/Directory.cls` 行157-200（Deleteメソッド）
- E-08: `Source/CorLib/System.IO/Directory.cls` 行412-432（Moveメソッド）
- E-09: `Source/CorLib/System.IO/Directory.cls` 行303-305（GetDirectoriesメソッド）
- E-10: `Source/CorLib/System.IO/Directory.cls` 行339-341（GetFilesメソッド）
- E-11: `Source/CorLib/System.IO/Directory.cls` 行540-589（GetFileSystemEntriesCore内部メソッド）
- E-12: `Source/CorLib/System.IO/Directory.cls` 行362-380（GetLogicalDrivesメソッド）
- E-13: `Source/CorLib/System.IO/Directory.cls` 行278-290（GetCurrentDirectoryメソッド）
- E-14: `Source/CorLib/System.IO/Directory.cls` 行440-451（SetCurrentDirectoryメソッド）
- E-15: `Source/CorLib/System.IO/Directory.cls` 行389-402（GetParentメソッド）
- E-16: `Source/CorLib/System.IO/Directory.cls` 行591-613（ValidateSearchPattern内部メソッド）
- E-17: `docs/code-to-docs/機能一覧/機能一覧.csv` 行36（機能定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Directoryクラスはディレクトリ操作の静的メソッドを提供する | E-02 | ○ |
| C-02 | Existsでディレクトリ存在確認が可能 | E-04 | ○ |
| C-03 | CreateDirectoryでディレクトリ作成が可能 | E-05 | ○ |
| C-04 | Deleteで再帰削除オプション対応 | E-07 | ○ |
| C-05 | Moveでディレクトリ移動が可能 | E-08 | ○ |
| C-06 | GetFiles/GetDirectoriesで一覧取得が可能 | E-09, E-10 | ○ |
| C-07 | SearchOptionで再帰検索を制御 | E-03 | ○ |
| C-08 | GetLogicalDrivesで論理ドライブ一覧取得 | E-12 | ○ |
| C-09 | GetCurrentDirectory/SetCurrentDirectoryでカレントディレクトリ操作 | E-13, E-14 | ○ |
| C-10 | GetParentで親ディレクトリ取得 | E-15 | ○ |
| C-11 | 移動元と移動先は同じドライブルートが必要 | E-08 | ○ |
| C-12 | 移動元と移動先が同じ場合はエラー | E-08 | ○ |
| C-13 | ".."を含む検索パターンは禁止 | E-16 | ○ |
| C-14 | 階層ごとにディレクトリを作成 | E-05, E-06 | ○ |
| C-15 | スタックを使って作成順序を管理 | E-06 | ○ |
| C-16 | 再帰削除は中身も含めて削除 | E-07 | ○ |
| C-17 | パス末尾のセパレータは除去される | E-05 | ○ |
| C-18 | AllDirectoriesでサブフォルダ再帰処理 | E-11 | ○ |
| C-19 | FindFirstFile/FindNextFileでエントリ列挙 | E-11 | ○ |
| C-20 | 機能一覧でNo.35として定義されている | E-17 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張にソースコードによる根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] 再帰削除の処理フローが正しく説明されているか確認
- [ ] GetFileSystemEntriesCoreの再帰処理が正確か確認
- [ ] 行番号の参照が実際のソースと一致しているか確認
