---
generated_at: 2026-01-20 16:29:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：36-FileInfo機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. 該当なし

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/CorLib/System.IO/FileInfo.cls` 行1-716（クラス全体）
- E-02: `Source/CorLib/System.IO/FileInfo.cls` 行38-50（クラスコメント）
- E-03: `Source/CorLib/System.IO/FileInfo.cls` 行59-67（プライベート変数）
- E-04: `Source/CorLib/System.IO/FileInfo.cls` 行519-527（コンストラクタ）
- E-05: `Source/CorLib/System.IO/FileInfo.cls` 行79-85（Attributesプロパティ）
- E-06: `Source/CorLib/System.IO/FileInfo.cls` 行329-335（Lengthプロパティ）
- E-07: `Source/CorLib/System.IO/FileInfo.cls` 行351-370（Refreshメソッド）
- E-08: `Source/CorLib/System.IO/FileInfo.cls` 行533-535（MarkDirty）
- E-09: `Source/CorLib/System.IO/FileInfo.cls` 行537-539（IsDirty）
- E-10: `Source/CorLib/System.IO/FileInfo.cls` 行388-391（CopyToメソッド）
- E-11: `Source/CorLib/System.IO/FileInfo.cls` 行432-447（MoveToメソッド）
- E-12: `Source/CorLib/System.IO/FileInfo.cls` 行416-424（Deleteメソッド）
- E-13: `Source/CorLib/System.IO/FileInfo.cls` 行295-301（Existsプロパティ）
- E-14: `Source/CorLib/System.IO/FileInfo.cls` 行569-579（シリアライズ）
- E-15: `docs/code-to-docs/機能一覧/機能一覧.csv` 行37（機能定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | FileInfoはファイル情報のインスタンスクラス | E-02 | ○ |
| C-02 | Attributesでファイル属性の取得・設定が可能 | E-05 | ○ |
| C-03 | Lengthでファイルサイズを取得可能 | E-06 | ○ |
| C-04 | Refreshで情報を再取得 | E-07 | ○ |
| C-05 | CopyToでファイルをコピー | E-10 | ○ |
| C-06 | MoveToでファイルを移動 | E-11 | ○ |
| C-07 | Deleteでファイルを削除 | E-12 | ○ |
| C-08 | Existsでファイル存在確認 | E-13 | ○ |
| C-09 | FileSystemInfoインターフェースを実装 | E-01 | ○ |
| C-10 | シリアライズ（PropertyBag）に対応 | E-14 | ○ |
| C-11 | ダーティフラグで情報の再取得を管理 | E-08, E-09 | ○ |
| C-12 | ファイルサイズはCurrency型で10000倍保持 | E-07 | ○ |
| C-13 | MoveToでパス情報も更新される | E-11 | ○ |
| C-14 | ファイルの存在は操作時まで確認されない | E-04 | ○ |
| C-15 | プライベート変数でパスとキャッシュを保持 | E-03 | ○ |
| C-16 | Class_InitializeでMarkDirtyを呼び出し | E-04 | ○ |
| C-17 | IsDirtyチェック後にRefreshを呼び出し | E-05 | ○ |
| C-18 | 機能一覧でNo.36として定義されている | E-15 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張にソースコードによる根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] ダーティフラグ管理のロジックが正しく説明されているか確認
- [ ] ファイルサイズのCurrency変換処理が正確か確認
- [ ] 行番号の参照が実際のソースと一致しているか確認
