---
generated_at: 2026-01-20 16:32:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：37-DirectoryInfo機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. 該当なし

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/CorLib/System.IO/DirectoryInfo.cls` 行1-717（クラス全体）
- E-02: `Source/CorLib/System.IO/DirectoryInfo.cls` 行38-44（クラスコメント）
- E-03: `Source/CorLib/System.IO/DirectoryInfo.cls` 行50-56（プライベート変数）
- E-04: `Source/CorLib/System.IO/DirectoryInfo.cls` 行552-559（コンストラクタ）
- E-05: `Source/CorLib/System.IO/DirectoryInfo.cls` 行87-92（Attributesプロパティ）
- E-06: `Source/CorLib/System.IO/DirectoryInfo.cls` 行327-344（Refreshメソッド）
- E-07: `Source/CorLib/System.IO/DirectoryInfo.cls` 行64-69（Nameプロパティ）
- E-08: `Source/CorLib/System.IO/DirectoryInfo.cls` 行360-362（Extensionプロパティ）
- E-09: `Source/CorLib/System.IO/DirectoryInfo.cls` 行369-376（Parentプロパティ）
- E-10: `Source/CorLib/System.IO/DirectoryInfo.cls` 行383-385（Rootプロパティ）
- E-11: `Source/CorLib/System.IO/DirectoryInfo.cls` 行390-392（Createメソッド）
- E-12: `Source/CorLib/System.IO/DirectoryInfo.cls` 行400-402（CreateSubdirectoryメソッド）
- E-13: `Source/CorLib/System.IO/DirectoryInfo.cls` 行449-453（MoveToメソッド）
- E-14: `Source/CorLib/System.IO/DirectoryInfo.cls` 行410-412（Deleteメソッド）
- E-15: `Source/CorLib/System.IO/DirectoryInfo.cls` 行422-442（GetDirectoriesメソッド）
- E-16: `Source/CorLib/System.IO/DirectoryInfo.cls` 行463-481（GetFilesメソッド）
- E-17: `Source/CorLib/System.IO/DirectoryInfo.cls` 行491-520（GetFileSystemInfosメソッド）
- E-18: `docs/code-to-docs/機能一覧/機能一覧.csv` 行38（機能定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DirectoryInfoはディレクトリ情報のインスタンスクラス | E-02 | ○ |
| C-02 | Attributesでディレクトリ属性の取得・設定が可能 | E-05 | ○ |
| C-03 | Refreshで情報を再取得 | E-06 | ○ |
| C-04 | Nameでディレクトリ名を取得 | E-07 | ○ |
| C-05 | Extensionは常に空文字列を返す | E-08 | ○ |
| C-06 | Parentで親ディレクトリ取得 | E-09 | ○ |
| C-07 | Rootでルートディレクトリ取得 | E-10 | ○ |
| C-08 | Createでディレクトリ作成 | E-11 | ○ |
| C-09 | CreateSubdirectoryでサブディレクトリ作成 | E-12 | ○ |
| C-10 | MoveToでディレクトリ移動 | E-13 | ○ |
| C-11 | Deleteでディレクトリ削除 | E-14 | ○ |
| C-12 | GetDirectoriesでサブディレクトリ一覧取得 | E-15 | ○ |
| C-13 | GetFilesでファイル一覧取得 | E-16 | ○ |
| C-14 | GetFileSystemInfosで混合一覧取得 | E-17 | ○ |
| C-15 | FileSystemInfoインターフェースを実装 | E-01 | ○ |
| C-16 | mIsDirtyでダーティフラグを管理 | E-03 | ○ |
| C-17 | MoveToでパス情報も更新される | E-13 | ○ |
| C-18 | 機能一覧でNo.37として定義されている | E-18 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張にソースコードによる根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] Refreshの処理フローが正しく説明されているか確認
- [ ] GetDirectories/GetFilesの配列生成処理が正確か確認
- [ ] 行番号の参照が実際のソースと一致しているか確認
