---
generated_at: 2026-01-20 11:15:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：4-TimeSpan.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **TimeSpanStaticの詳細実装**：別ファイルのため未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/CorLib/System/TimeSpan.cls` 38-50行目（モジュールコメント）
- E-02: `Source/CorLib/System/TimeSpan.cls` 52-54行目（インターフェース実装宣言）
- E-03: `Source/CorLib/System/TimeSpan.cls` 56-59行目（定数と内部変数）
- E-04: `Source/CorLib/System/TimeSpan.cls` 67-69行目（Addメソッド）
- E-05: `Source/CorLib/System/TimeSpan.cls` 76-78行目（Subtractメソッド）
- E-06: `Source/CorLib/System/TimeSpan.cls` 84-90行目（Durationメソッド）
- E-07: `Source/CorLib/System/TimeSpan.cls` 98-100行目（TotalMillisecondsプロパティ）
- E-08: `Source/CorLib/System/TimeSpan.cls` 108-110行目（TotalSecondsプロパティ）
- E-09: `Source/CorLib/System/TimeSpan.cls` 118-120行目（TotalMinutesプロパティ）
- E-10: `Source/CorLib/System/TimeSpan.cls` 126-128行目（TotalHoursプロパティ）
- E-11: `Source/CorLib/System/TimeSpan.cls` 136-138行目（TotalDaysプロパティ）
- E-12: `Source/CorLib/System/TimeSpan.cls` 146-148行目（Millisecondsプロパティ）
- E-13: `Source/CorLib/System/TimeSpan.cls` 156-158行目（Secondsプロパティ）
- E-14: `Source/CorLib/System/TimeSpan.cls` 166-168行目（Minutesプロパティ）
- E-15: `Source/CorLib/System/TimeSpan.cls` 176-178行目（Hoursプロパティ）
- E-16: `Source/CorLib/System/TimeSpan.cls` 186-188行目（Daysプロパティ）
- E-17: `Source/CorLib/System/TimeSpan.cls` 195-197行目（Ticksプロパティ）
- E-18: `Source/CorLib/System/TimeSpan.cls` 211-213行目（CompareToメソッド）
- E-19: `Source/CorLib/System/TimeSpan.cls` 219-221行目（Negateメソッド）
- E-20: `Source/CorLib/System/TimeSpan.cls` 230-232行目（ToStringメソッド）
- E-21: `Source/CorLib/System/TimeSpan.cls` 240-242行目（Equalsメソッド）
- E-22: `Source/CorLib/System/TimeSpan.cls` 248-252行目（GetHashCodeメソッド）
- E-23: `Source/CorLib/System/TimeSpan.cls` 258-264行目（Init/InitFromMillisecondsメソッド）
- E-24: `Source/CorLib/System/TimeSpan.cls` 270-276行目（シリアライズ処理）
- E-25: `Source/CorLib/System/TimeSpan.cls` 282-322行目（インターフェース実装）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 時間の長さをミリ秒で内部表現 | E-01, E-03 | ○ |
| C-02 | IObject、IComparable、IFormattableを実装 | E-02 | ○ |
| C-03 | Currency型で64ビット整数相当の精度 | E-03 | ○ |
| C-04 | AddはTimeSpan.Addに委譲 | E-04 | ○ |
| C-05 | SubtractはTimeSpan.Subtractに委譲 | E-05 | ○ |
| C-06 | Durationは絶対値を返す | E-06 | ○ |
| C-07 | TotalMillisecondsはCurrency型で返す | E-07 | ○ |
| C-08 | TotalSecondsはミリ秒を秒に変換 | E-08 | ○ |
| C-09 | TotalMinutes/TotalHours/TotalDaysは除算で計算 | E-09, E-10, E-11 | ○ |
| C-10 | Millisecondsは部分値（Mod 1000） | E-12 | ○ |
| C-11 | Seconds/Minutes/Hoursは各単位でMod | E-13, E-14, E-15 | ○ |
| C-12 | DaysはMilliSecondsPerDayで除算 | E-16 | ○ |
| C-13 | TicksはDecimal型で返す | E-17 | ○ |
| C-14 | CompareToはTimeSpan.Compareに委譲 | E-18 | ○ |
| C-15 | Negateは符号反転 | E-19 | ○ |
| C-16 | ToStringはTimeSpan.ToStringに委譲 | E-20 | ○ |
| C-17 | EqualsはTimeSpan.Equalsに委譲 | E-21 | ○ |
| C-18 | GetHashCodeはXORベース | E-22 | ○ |
| C-19 | Initは日時分秒ミリ秒からミリ秒を計算 | E-23 | ○ |
| C-20 | 永続化可能（PropertyBag使用） | E-24 | ○ |
| C-21 | IComparable.CompareToでTimeSpan以外はエラー | E-25 | ○ |
| C-22 | 表示形式は[-][d.]hh:mm:ss[.ff] | E-01 | ○ |
| C-23 | 負の時間間隔を表現可能 | E-06 | ○ |
| C-24 | TimeSpanStaticの詳細実装 | **別ファイル未確認** | △ |

## 4) 不足情報（Unknown / Missing）
- TimeSpanStaticクラスの詳細実装
  - 候補：`Source/CorLib/System/TimeSpanStatic.cls` の確認が必要
  - FromMilliseconds、FromSeconds、FromMinutes等のファクトリメソッド
  - Add、Subtract、Compare、Equals等の静的メソッド

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - TimeSpanクラス自体の実装は完全に確認済み
- 0: 低リスク - 内部表現と計算ロジックは単純で明確
- 0: 低リスク - インターフェース実装は標準的

## 6) レビュアーチェックリスト（最小）
- [ ] TimeSpanStaticの実装確認（FromMilliseconds、Add、Subtract等）
- [ ] 書式設定の詳細実装確認（TimeSpan.ToString）
- [ ] オーバーフロー時の挙動確認
- [ ] 負の値の処理が正しいか確認
