---
generated_at: 2026-01-20 17:10:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：機能設計書 42-Encoding

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. なし（全ての主張にソースコードによる根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/CorLib/System.Text/Encoding.cls` 38-49行目 - クラスコメント（概要説明）
- E-02: `Source/CorLib/System.Text/Encoding.cls` 151行目 - GetByteCountメソッド定義
- E-03: `Source/CorLib/System.Text/Encoding.cls` 165行目 - GetBytesメソッド定義
- E-04: `Source/CorLib/System.Text/Encoding.cls` 181行目 - GetBytesExメソッド定義
- E-05: `Source/CorLib/System.Text/Encoding.cls` 194行目 - GetCharCountメソッド定義
- E-06: `Source/CorLib/System.Text/Encoding.cls` 209行目 - GetCharsメソッド定義
- E-07: `Source/CorLib/System.Text/Encoding.cls` 226行目 - GetCharsExメソッド定義
- E-08: `Source/CorLib/System.Text/Encoding.cls` 244行目 - GetDecoderメソッド定義
- E-09: `Source/CorLib/System.Text/Encoding.cls` 261行目 - GetEncoderメソッド定義
- E-10: `Source/CorLib/System.Text/Encoding.cls` 270行目 - DecoderFallbackプロパティ
- E-11: `Source/CorLib/System.Text/Encoding.cls` 288行目 - EncoderFallbackプロパティ
- E-12: `Source/CorLib/System.Text/Encoding.cls` 327行目 - GetPreambleメソッド定義
- E-13: `Source/CorLib/System.Text/Encoding.cls` 341行目 - GetStringメソッド定義
- E-14: `Source/CorLib/System.Text/Encoding.cls` 57行目 - IsReadOnlyプロパティ
- E-15: `Source/CorLib/System.Text/Encoding.cls` 68行目 - Cloneメソッド定義
- E-16: `Source/CorLib/System.Text/Encoding.cls` 82行目 - CodePageプロパティ
- E-17: `Source/CorLib/System.Text/EncodingStatic.cls` 80-86行目 - Defaultプロパティ
- E-18: `Source/CorLib/System.Text/EncodingStatic.cls` 225-265行目 - GetEncodingメソッド
- E-19: `Source/CorLib/System.Text/EncodingStatic.cls` 50-59行目 - キャッシュ用プライベート変数
- E-20: `Source/CorLib/System.Text/EncodingStatic.cls` 206-215行目 - Convertメソッド
- E-21: `Source/CorLib/System.Text/EncodingStatic.cls` 281-287行目 - GetEncodingsメソッド
- E-22: `docs/code-to-docs/機能一覧/機能一覧.csv` 43行目 - 機能一覧での定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Encodingは文字とバイト配列間の変換インターフェースを定義 | E-01 | ○ |
| C-02 | GetByteCountで必要バイト数を計算 | E-02 | ○ |
| C-03 | GetBytesで文字→バイト配列変換 | E-03 | ○ |
| C-04 | GetBytesExで既存配列に書き込み | E-04 | ○ |
| C-05 | GetCharCountで生成文字数を計算 | E-05 | ○ |
| C-06 | GetCharsでバイト→文字配列変換 | E-06 | ○ |
| C-07 | GetCharsExで既存配列に書き込み | E-07 | ○ |
| C-08 | GetDecoderでストリーム用デコーダ取得 | E-08 | ○ |
| C-09 | GetEncoderでストリーム用エンコーダ取得 | E-09 | ○ |
| C-10 | DecoderFallbackでデコード時のフォールバック制御 | E-10 | ○ |
| C-11 | EncoderFallbackでエンコード時のフォールバック制御 | E-11 | ○ |
| C-12 | GetPreambleでBOMを取得 | E-12 | ○ |
| C-13 | GetStringでバイト→文字列変換 | E-13 | ○ |
| C-14 | IsReadOnlyで読み取り専用判定 | E-14 | ○ |
| C-15 | Cloneで書き込み可能なコピーを作成 | E-15 | ○ |
| C-16 | CodePageでエンコーディング識別 | E-16 | ○ |
| C-17 | EncodingStatic.Defaultでシステムデフォルト取得 | E-17 | ○ |
| C-18 | GetEncodingでコードページ/名前からインスタンス取得 | E-18 | ○ |
| C-19 | エンコーディングインスタンスはキャッシュされる | E-19 | ○ |
| C-20 | Convertでエンコーディング間変換 | E-20 | ○ |
| C-21 | GetEncodingsで利用可能エンコーディング一覧取得 | E-21 | ○ |
| C-22 | UTF8/UTF7/UTF32/Unicode/ASCII等の実装クラスが存在 | E-01, E-19 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全ての主張はソースコードにより裏付けられている。

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：Encodingはインターフェース定義クラスであり、実装の詳細は各派生クラスに委譲されている

## 6) レビュアーチェックリスト（最小）
- [ ] Encoding.clsが適切にインターフェースとして機能しているか確認
- [ ] EncodingStatic.clsのGetEncodingメソッドのコードページマッピングが正確か確認
- [ ] フォールバック機能（EncoderFallback/DecoderFallback）の動作を確認
- [ ] 各派生クラス（UTF8Encoding等）がEncodingインターフェースを正しく実装しているか確認
