---
generated_at: 2026-01-20 17:20:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：機能設計書 43-UTF8Encoding

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  1. なし（全ての主張にソースコードによる根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/CorLib/System.Text/UTF8Encoding.cls` 37-47行目 - UTF-8エンコーディング規則のコメント
- E-02: `Source/CorLib/System.Text/UTF8Encoding.cls` 63行目 - CODE_PAGE定数（65001）
- E-03: `Source/CorLib/System.Text/UTF8Encoding.cls` 79-90行目 - プライベートメンバ変数定義
- E-04: `Source/CorLib/System.Text/UTF8Encoding.cls` 59-61行目 - Implements宣言（IObject, Encoding, ICloneable）
- E-05: `Source/CorLib/System.Text/UTF8Encoding.cls` 276-296行目 - GetByteCountメソッド
- E-06: `Source/CorLib/System.Text/UTF8Encoding.cls` 310-330行目 - GetBytesメソッド
- E-07: `Source/CorLib/System.Text/UTF8Encoding.cls` 346-361行目 - GetBytesExメソッド
- E-08: `Source/CorLib/System.Text/UTF8Encoding.cls` 374-380行目 - GetCharCountメソッド
- E-09: `Source/CorLib/System.Text/UTF8Encoding.cls` 395-404行目 - GetCharsメソッド
- E-10: `Source/CorLib/System.Text/UTF8Encoding.cls` 439-459行目 - GetStringメソッド
- E-11: `Source/CorLib/System.Text/UTF8Encoding.cls` 466-472行目 - GetPreambleメソッド（BOM: EF BB BF）
- E-12: `Source/CorLib/System.Text/UTF8Encoding.cls` 483-506行目 - GetMaxByteCountメソッド
- E-13: `Source/CorLib/System.Text/UTF8Encoding.cls` 518-535行目 - GetMaxCharCountメソッド
- E-14: `Source/CorLib/System.Text/UTF8Encoding.cls` 546-550行目 - GetEncoderメソッド
- E-15: `Source/CorLib/System.Text/UTF8Encoding.cls` 563-567行目 - GetDecoderメソッド
- E-16: `Source/CorLib/System.Text/UTF8Encoding.cls` 611-618行目 - Initメソッド（コンストラクタ）
- E-17: `Source/CorLib/System.Text/UTF8Encoding.cls` 626-640行目 - Class_InitPropertiesメソッド（デフォルト初期化）
- E-18: `Source/CorLib/System.Text/UTF8Encoding.cls` 650-945行目 - GetCharCountCoreメソッド
- E-19: `Source/CorLib/System.Text/UTF8Encoding.cls` 976-1367行目 - GetCharsCoreメソッド
- E-20: `Source/CorLib/System.Text/UTF8Encoding.cls` 1464-1588行目 - GetByteCountCoreメソッド
- E-21: `Source/CorLib/System.Text/UTF8Encoding.cls` 1590-1822行目 - GetBytesCoreメソッド
- E-22: `Source/CorLib/System.Text/UTF8Encoding.cls` 229-236行目 - DecoderFallback Setプロパティ（読み取り専用チェック）
- E-23: `Source/CorLib/System.Text/UTF8Encoding.cls` 107-110行目 - Cloneメソッド
- E-24: `docs/code-to-docs/機能一覧/機能一覧.csv` 44行目 - 機能一覧での定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UTF8EncodingはUnicode文字をUTF-8バイト配列に変換する | E-01, E-06 | ○ |
| C-02 | UTF8EncodingはUTF-8バイト配列をUnicode文字に変換する | E-09, E-10 | ○ |
| C-03 | Encodingインターフェースを実装している | E-04 | ○ |
| C-04 | CodePageは65001を返す | E-02 | ○ |
| C-05 | GetByteCountでエンコードに必要なバイト数を計算 | E-05 | ○ |
| C-06 | GetBytesで文字→バイト配列変換 | E-06 | ○ |
| C-07 | GetBytesExで既存バッファにエンコード | E-07 | ○ |
| C-08 | GetCharCountでデコード文字数を計算 | E-08 | ○ |
| C-09 | GetCharsでバイト→文字配列変換 | E-09 | ○ |
| C-10 | GetStringでバイト→文字列変換 | E-10 | ○ |
| C-11 | GetPreambleでBOM（EF BB BF）を返す | E-11 | ○ |
| C-12 | EmitUTF8Identifier=FalseのときGetPreambleは空配列 | E-11 | ○ |
| C-13 | GetMaxByteCountで最大バイト数を計算 | E-12 | ○ |
| C-14 | GetMaxCharCountで最大文字数を計算 | E-13 | ○ |
| C-15 | GetEncoderでUTF8Encoderを取得 | E-14 | ○ |
| C-16 | GetDecoderでUTF8Decoderを取得 | E-15 | ○ |
| C-17 | ASCII文字（< 0x80）は1バイトでエンコード | E-01, E-21 | ○ |
| C-18 | サロゲートペアは4バイトでエンコード | E-01, E-21 | ○ |
| C-19 | 不正バイト列はDecoderFallbackで処理 | E-18, E-19 | ○ |
| C-20 | 読み取り専用インスタンスはフォールバック設定変更不可 | E-22 | ○ |
| C-21 | Cloneで書き込み可能なコピーを作成 | E-23 | ○ |
| C-22 | デフォルトではReplacementFallbackを使用 | E-17 | ○ |
| C-23 | ThrowOnInvalidBytes=TrueでExceptionFallbackを使用 | E-16 | ○ |
| C-24 | ASCII文字に対する高速ループ最適化を実装 | E-18, E-19, E-20, E-21 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全ての主張はソースコードにより裏付けられている。

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：全ての機能仕様がソースコードから直接確認可能
- UTF-8エンコーディングの規則はRFCおよび.NET Frameworkと互換性あり

## 6) レビュアーチェックリスト（最小）
- [ ] UTF8Encoding.clsの行番号が正確か確認
- [ ] UTF-8エンコーディング規則（1-4バイト）の実装が正確か確認
- [ ] サロゲートペア処理の正確性を確認
- [ ] 高速ループ最適化の動作を確認
- [ ] フォールバック処理が正しく動作するか確認
- [ ] BOM（EF BB BF）の出力制御が正確か確認
