---
generated_at: 2026-01-20 17:30:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：機能設計書 44-UTF7Encoding

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. なし（全ての主張にソースコードによる根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/CorLib/System.Text/UTF7Encoding.cls` 38-47行目 - クラスコメント（概要説明）
- E-02: `Source/CorLib/System.Text/UTF7Encoding.cls` 53行目 - EncodableCharacters定数
- E-03: `Source/CorLib/System.Text/UTF7Encoding.cls` 54行目 - OptionalCharacters定数
- E-04: `Source/CorLib/System.Text/UTF7Encoding.cls` 57行目 - mDirectlyEncodable配列
- E-05: `Source/CorLib/System.Text/UTF7Encoding.cls` 180-182行目 - CodePageプロパティ（65000）
- E-06: `Source/CorLib/System.Text/UTF7Encoding.cls` 248-265行目 - GetByteCountメソッド
- E-07: `Source/CorLib/System.Text/UTF7Encoding.cls` 278-298行目 - GetBytesメソッド
- E-08: `Source/CorLib/System.Text/UTF7Encoding.cls` 367-373行目 - GetCharCountメソッド
- E-09: `Source/CorLib/System.Text/UTF7Encoding.cls` 383-392行目 - GetCharsメソッド
- E-10: `Source/CorLib/System.Text/UTF7Encoding.cls` 340-357行目 - GetStringメソッド
- E-11: `Source/CorLib/System.Text/UTF7Encoding.cls` 448-450行目 - GetPreambleメソッド（空配列）
- E-12: `Source/CorLib/System.Text/UTF7Encoding.cls` 435-440行目 - GetMaxByteCountメソッド
- E-13: `Source/CorLib/System.Text/UTF7Encoding.cls` 418-427行目 - GetMaxCharCountメソッド
- E-14: `Source/CorLib/System.Text/UTF7Encoding.cls` 460-464行目 - GetEncoderメソッド
- E-15: `Source/CorLib/System.Text/UTF7Encoding.cls` 478-482行目 - GetDecoderメソッド
- E-16: `Source/CorLib/System.Text/UTF7Encoding.cls` 520-525行目 - Initメソッド
- E-17: `Source/CorLib/System.Text/UTF7Encoding.cls` 532-537行目 - Class_Initializeメソッド
- E-18: `Source/CorLib/System.Text/UTF7Encoding.cls` 564-688行目 - GetBytesCore（修正Base64処理）
- E-19: `Source/CorLib/System.Text/UTF7Encoding.cls` 833-948行目 - GetCharsCore（デコード処理）
- E-20: `docs/code-to-docs/機能一覧/機能一覧.csv` 45行目 - 機能一覧での定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UTF7EncodingはUnicode文字をUTF-7バイト配列に変換する | E-01, E-07 | ○ |
| C-02 | UTF7EncodingはUTF-7バイト配列をUnicode文字に変換する | E-09, E-10 | ○ |
| C-03 | 直接エンコード可能文字はTab/LF/CR/Space/'(),-./0-9:?A-Za-z | E-02 | ○ |
| C-04 | オプション文字は!"#$%&*;<=>@[]^_`{&#124;} | E-03 | ○ |
| C-05 | mDirectlyEncodableで直接エンコード判定 | E-04 | ○ |
| C-06 | CodePageは65000を返す | E-05 | ○ |
| C-07 | GetByteCountでエンコードに必要なバイト数を計算 | E-06 | ○ |
| C-08 | GetBytesで文字→バイト配列変換 | E-07 | ○ |
| C-09 | GetCharCountでデコード文字数を計算 | E-08 | ○ |
| C-10 | GetCharsでバイト→文字配列変換 | E-09 | ○ |
| C-11 | GetStringでバイト→文字列変換 | E-10 | ○ |
| C-12 | GetPreambleは空配列を返す（BOMなし） | E-11 | ○ |
| C-13 | GetMaxByteCount = CharCount * 3 + 2 | E-12 | ○ |
| C-14 | GetMaxCharCount = ByteCount（ByteCount > 0）または1 | E-13 | ○ |
| C-15 | GetEncoderでUTF7Encoderを取得 | E-14 | ○ |
| C-16 | GetDecoderでUTF7Decoderを取得 | E-15 | ○ |
| C-17 | AllowOptionals設定時にオプション文字を直接エンコード | E-16 | ○ |
| C-18 | デフォルトでEncoderReplacementFallback（空文字）を使用 | E-17 | ○ |
| C-19 | 非直接エンコード文字は修正Base64でエンコード | E-18 | ○ |
| C-20 | "+"文字は"+-"としてエスケープ | E-18, E-19 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全ての主張はソースコードにより裏付けられている。

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：全ての機能仕様がソースコードから直接確認可能
- UTF-7はセキュリティ上の問題があるため、使用は限定的であることを確認

## 6) レビュアーチェックリスト（最小）
- [ ] UTF7Encoding.clsの行番号が正確か確認
- [ ] 直接エンコード可能文字セットがRFC 2152と一致するか確認
- [ ] 修正Base64エンコード/デコードの実装が正確か確認
- [ ] "+"文字のエスケープ処理（"+-"）が正しく動作するか確認
- [ ] フォールバック処理が正しく動作するか確認
