---
generated_at: 2026-01-20 17:40:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：機能設計書 45-UTF32Encoding

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. なし（全ての主張にソースコードによる根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/CorLib/System.Text/UTF32Encoding.cls` 38-45行目 - クラスコメント（概要説明）
- E-02: `Source/CorLib/System.Text/UTF32Encoding.cls` 54-59行目 - プライベートメンバ変数定義
- E-03: `Source/CorLib/System.Text/UTF32Encoding.cls` 161-163行目 - CodePageプロパティ
- E-04: `Source/CorLib/System.Text/UTF32Encoding.cls` 252-267行目 - GetByteCountメソッド
- E-05: `Source/CorLib/System.Text/UTF32Encoding.cls` 279-302行目 - GetBytesメソッド
- E-06: `Source/CorLib/System.Text/UTF32Encoding.cls` 349-354行目 - GetCharCountメソッド
- E-07: `Source/CorLib/System.Text/UTF32Encoding.cls` 364-373行目 - GetCharsメソッド
- E-08: `Source/CorLib/System.Text/UTF32Encoding.cls` 567-587行目 - GetStringメソッド
- E-09: `Source/CorLib/System.Text/UTF32Encoding.cls` 519-529行目 - GetPreambleメソッド（BOM）
- E-10: `Source/CorLib/System.Text/UTF32Encoding.cls` 453-476行目 - GetMaxByteCountメソッド
- E-11: `Source/CorLib/System.Text/UTF32Encoding.cls` 414-445行目 - GetMaxCharCountメソッド
- E-12: `Source/CorLib/System.Text/UTF32Encoding.cls` 489-494行目 - GetEncoderメソッド
- E-13: `Source/CorLib/System.Text/UTF32Encoding.cls` 506-511行目 - GetDecoderメソッド
- E-14: `Source/CorLib/System.Text/UTF32Encoding.cls` 633-645行目 - Initメソッド
- E-15: `Source/CorLib/System.Text/UTF32Encoding.cls` 656-661行目 - Class_InitPropertiesメソッド
- E-16: `Source/CorLib/System.Text/UTF32Encoding.cls` 675-787行目 - GetBytesCore（エンコード処理）
- E-17: `Source/CorLib/System.Text/UTF32Encoding.cls` 852-981行目 - GetCharsCore（デコード処理）
- E-18: `Source/CorLib/System.Text/UTF32Encoding.cls` 706-724行目 - BMP文字のエンコード
- E-19: `Source/CorLib/System.Text/UTF32Encoding.cls` 735-758行目 - サロゲートペアの結合
- E-20: `Source/CorLib/System.Text/UTF32Encoding.cls` 930-940行目 - サロゲートペアの分解
- E-21: `Source/CorLib/System.Text/UTF32Encoding.cls` 907-909行目 - エンディアン変換（SwapEndian）
- E-22: `docs/code-to-docs/機能一覧/機能一覧.csv` 46行目 - 機能一覧での定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UTF32EncodingはUnicode文字をUTF-32バイト配列に変換する | E-01, E-05 | ○ |
| C-02 | UTF32EncodingはUTF-32バイト配列をUnicode文字に変換する | E-07, E-08 | ○ |
| C-03 | 1文字は常に4バイトでエンコードされる | E-16, E-18 | ○ |
| C-04 | ビッグエンディアン/リトルエンディアンをサポート | E-02, E-14 | ○ |
| C-05 | CodePageはLE=12000、BE=12001を返す | E-03, E-14, E-15 | ○ |
| C-06 | GetByteCountでエンコードに必要なバイト数を計算 | E-04 | ○ |
| C-07 | GetBytesで文字→バイト配列変換 | E-05 | ○ |
| C-08 | GetCharCountでデコード文字数を計算 | E-06 | ○ |
| C-09 | GetCharsでバイト→文字配列変換 | E-07 | ○ |
| C-10 | GetStringでバイト→文字列変換 | E-08 | ○ |
| C-11 | GetPreambleでBOMを返す（LE: FF FE 00 00、BE: 00 00 FE FF） | E-09 | ○ |
| C-12 | mEmitBOM=FalseのときGetPreambleは空配列 | E-09 | ○ |
| C-13 | GetMaxByteCount = (CharCount + 1) * EncoderFallback.MaxCharCount * 4 | E-10 | ○ |
| C-14 | GetMaxCharCount = ByteCount / 2 + 2 | E-11 | ○ |
| C-15 | GetEncoderでUTF32Encoderを取得 | E-12 | ○ |
| C-16 | GetDecoderでUTF32Decoderを取得 | E-13 | ○ |
| C-17 | サロゲートペアを結合して単一の32ビット値にエンコード | E-19 | ○ |
| C-18 | U+10000以上の値をサロゲートペアに分解してデコード | E-20 | ○ |
| C-19 | ビッグエンディアン時にSwapEndianでバイト順を変換 | E-21 | ○ |
| C-20 | デフォルトでReplacementFallback（FFFD）を使用 | E-15 | ○ |
| C-21 | ThrowOnInvalidBytes=TrueでExceptionFallbackを使用 | E-14 | ○ |
| C-22 | 不正サロゲートはフォールバック処理 | E-16 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全ての主張はソースコードにより裏付けられている。

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：全ての機能仕様がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] UTF32Encoding.clsの行番号が正確か確認
- [ ] BOM（FF FE 00 00 / 00 00 FE FF）の出力が正確か確認
- [ ] サロゲートペアの結合/分解処理の正確性を確認
- [ ] エンディアン変換（SwapEndian）の動作を確認
- [ ] フォールバック処理が正しく動作するか確認
