---
generated_at: 2026-01-20 17:50:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：機能設計書 46-UnicodeEncoding

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. なし（全ての主張にソースコードによる根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/CorLib/System.Text/UnicodeEncoding.cls` 47-55行目 - クラスコメント（概要説明）
- E-02: `Source/CorLib/System.Text/UnicodeEncoding.cls` 68-77行目 - プライベートメンバ変数定義
- E-03: `Source/CorLib/System.Text/UnicodeEncoding.cls` 207-209行目 - CodePageプロパティ
- E-04: `Source/CorLib/System.Text/UnicodeEncoding.cls` 299-314行目 - GetByteCountメソッド
- E-05: `Source/CorLib/System.Text/UnicodeEncoding.cls` 328-350行目 - GetBytesメソッド
- E-06: `Source/CorLib/System.Text/UnicodeEncoding.cls` 399-405行目 - GetCharCountメソッド
- E-07: `Source/CorLib/System.Text/UnicodeEncoding.cls` 418-428行目 - GetCharsメソッド
- E-08: `Source/CorLib/System.Text/UnicodeEncoding.cls` 461-481行目 - GetStringメソッド
- E-09: `Source/CorLib/System.Text/UnicodeEncoding.cls` 488-499行目 - GetPreambleメソッド（BOM）
- E-10: `Source/CorLib/System.Text/UnicodeEncoding.cls` 505-528行目 - GetMaxByteCountメソッド
- E-11: `Source/CorLib/System.Text/UnicodeEncoding.cls` 534-572行目 - GetMaxCharCountメソッド
- E-12: `Source/CorLib/System.Text/UnicodeEncoding.cls` 577-581行目 - GetEncoderメソッド
- E-13: `Source/CorLib/System.Text/UnicodeEncoding.cls` 586-590行目 - GetDecoderメソッド
- E-14: `Source/CorLib/System.Text/UnicodeEncoding.cls` 631-643行目 - Initメソッド
- E-15: `Source/CorLib/System.Text/UnicodeEncoding.cls` 660-665行目 - Class_InitPropertiesメソッド
- E-16: `Source/CorLib/System.Text/UnicodeEncoding.cls` 694-815行目 - GetByteCountCore（高速ループ含む）
- E-17: `Source/CorLib/System.Text/UnicodeEncoding.cls` 817-1011行目 - GetBytesCore（高速ループ含む）
- E-18: `Source/CorLib/System.Text/UnicodeEncoding.cls` 1127-1357行目 - GetCharsCore（高速ループ含む）
- E-19: `Source/CorLib/System.Text/UnicodeEncoding.cls` 713-741行目 - FastLoop（非サロゲートスキップ）
- E-20: `Source/CorLib/System.Text/UnicodeEncoding.cls` 742-776行目 - サロゲートペア検証
- E-21: `Source/CorLib/System.Text/UnicodeEncoding.cls` 905-990行目 - エンディアン変換とバイト出力
- E-22: `docs/code-to-docs/機能一覧/機能一覧.csv` 47行目 - 機能一覧での定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UnicodeEncodingはUnicode文字をUTF-16バイト配列に変換する | E-01, E-05 | ○ |
| C-02 | UnicodeEncodingはUTF-16バイト配列をUnicode文字に変換する | E-07, E-08 | ○ |
| C-03 | BMP文字は2バイトでエンコードされる | E-16, E-17 | ○ |
| C-04 | サロゲートペアは4バイト（各2バイト）でエンコードされる | E-20, E-17 | ○ |
| C-05 | ビッグエンディアン/リトルエンディアンをサポート | E-02, E-14 | ○ |
| C-06 | CodePageはLE=1200、BE=1201を返す | E-03, E-14 | ○ |
| C-07 | GetByteCountでエンコードに必要なバイト数を計算 | E-04 | ○ |
| C-08 | GetBytesで文字→バイト配列変換 | E-05 | ○ |
| C-09 | GetCharCountでデコード文字数を計算 | E-06 | ○ |
| C-10 | GetCharsでバイト→文字配列変換 | E-07 | ○ |
| C-11 | GetStringでバイト→文字列変換 | E-08 | ○ |
| C-12 | GetPreambleでBOMを返す（LE: FF FE、BE: FE FF） | E-09 | ○ |
| C-13 | mEmitBOM=FalseのときGetPreambleは空配列 | E-09 | ○ |
| C-14 | GetMaxByteCount = (CharCount + 1) * 2 | E-10 | ○ |
| C-15 | GetEncoderでUnicodeEncoderを取得 | E-12 | ○ |
| C-16 | GetDecoderでUnicodeDecoderを取得 | E-13 | ○ |
| C-17 | 孤立サロゲートはフォールバック処理 | E-20 | ○ |
| C-18 | デフォルトでReplacementFallback（FFFD）を使用 | E-15 | ○ |
| C-19 | ThrowOnInvalidBytes=TrueでExceptionFallbackを使用 | E-14 | ○ |
| C-20 | 高速ループ（FastLoop）で非サロゲート文字を一括処理 | E-19 | ○ |
| C-21 | ビッグエンディアン時にバイト順序を入れ替え | E-21 | ○ |
| C-22 | VB6/VBA内部表現と同一のフォーマット | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全ての主張はソースコードにより裏付けられている。

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：全ての機能仕様がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] UnicodeEncoding.clsの行番号が正確か確認
- [ ] BOM（FF FE / FE FF）の出力が正確か確認
- [ ] サロゲートペアの検証処理の正確性を確認
- [ ] 高速ループ（FastLoop）の動作を確認
- [ ] エンディアン変換の動作を確認
- [ ] フォールバック処理が正しく動作するか確認
