---
generated_at: 2026-01-20 18:10:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：機能設計書 48-StringBuilder

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. なし（全ての主張にソースコードによる根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/CorLib/System.Text/StringBuilder.cls` 38-48行目 - クラスコメント（概要説明）
- E-02: `Source/CorLib/System.Text/StringBuilder.cls` 52-59行目 - プライベート変数・定数定義
- E-03: `Source/CorLib/System.Text/StringBuilder.cls` 71-82行目 - Appendメソッド
- E-04: `Source/CorLib/System.Text/StringBuilder.cls` 92-118行目 - AppendCharメソッド
- E-05: `Source/CorLib/System.Text/StringBuilder.cls` 129-133行目 - AppendFormatメソッド
- E-06: `Source/CorLib/System.Text/StringBuilder.cls` 183-190行目 - AppendLineメソッド
- E-07: `Source/CorLib/System.Text/StringBuilder.cls` 197-211行目 - AppendStringメソッド
- E-08: `Source/CorLib/System.Text/StringBuilder.cls` 220-237行目 - CopyToメソッド
- E-09: `Source/CorLib/System.Text/StringBuilder.cls` 245-271行目 - Capacityプロパティ
- E-10: `Source/CorLib/System.Text/StringBuilder.cls` 279-285行目 - Charsプロパティ（Get）
- E-11: `Source/CorLib/System.Text/StringBuilder.cls` 296-301行目 - Charsプロパティ（Let）
- E-12: `Source/CorLib/System.Text/StringBuilder.cls` 310-324行目 - EnsureCapacityメソッド
- E-13: `Source/CorLib/System.Text/StringBuilder.cls` 388-391行目 - Clearメソッド
- E-14: `Source/CorLib/System.Text/StringBuilder.cls` 400-423行目 - Insertメソッド
- E-15: `Source/CorLib/System.Text/StringBuilder.cls` 461-484行目 - Lengthプロパティ
- E-16: `Source/CorLib/System.Text/StringBuilder.cls` 493-507行目 - Removeメソッド
- E-17: `Source/CorLib/System.Text/StringBuilder.cls` 518-554行目 - Replaceメソッド
- E-18: `Source/CorLib/System.Text/StringBuilder.cls` 563-586行目 - ToStringメソッド
- E-19: `Source/CorLib/System.Text/StringBuilder.cls` 652-775行目 - AppendFormatArrayExメソッド
- E-20: `Source/CorLib/System.Text/StringBuilder.cls` 781-812行目 - Initメソッド（コンストラクタ）
- E-21: `Source/CorLib/System.Text/StringBuilder.cls` 814-819行目 - Class_Initializeメソッド
- E-22: `docs/code-to-docs/機能一覧/機能一覧.csv` 49行目 - 機能一覧での定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | StringBuilderは可変長の文字列を効率的に構築する | E-01 | ○ |
| C-02 | 内部バッファはInteger配列（mString） | E-02 | ○ |
| C-03 | デフォルト容量は128文字 | E-02, E-21 | ○ |
| C-04 | Appendで値を追加、型に応じて処理を分岐 | E-03 | ○ |
| C-05 | AppendCharで文字を指定回数追加 | E-04 | ○ |
| C-06 | AppendFormatで書式付き文字列を追加 | E-05, E-19 | ○ |
| C-07 | AppendLineで文字列+改行を追加 | E-06 | ○ |
| C-08 | AppendStringで高速な文字列追加 | E-07 | ○ |
| C-09 | CopyToで内部バッファから配列にコピー | E-08 | ○ |
| C-10 | Capacityで容量を取得/設定 | E-09 | ○ |
| C-11 | Charsで指定位置の文字を取得/設定 | E-10, E-11 | ○ |
| C-12 | EnsureCapacityでバッファを拡張（現在の2倍または要求量） | E-12 | ○ |
| C-13 | ClearでLength=0に設定 | E-13 | ○ |
| C-14 | Insertで文字列を挿入 | E-14 | ○ |
| C-15 | Lengthで現在の文字列長を取得/設定 | E-15 | ○ |
| C-16 | Length拡張時はFillCharacterでパディング | E-15 | ○ |
| C-17 | Removeで文字列を削除 | E-16 | ○ |
| C-18 | Replaceで文字列を置換 | E-17 | ○ |
| C-19 | ToStringで構築した文字列を取得 | E-18 | ○ |
| C-20 | 書式文字列は{index,width:format}形式をサポート | E-19 | ○ |
| C-21 | 多くのメソッドはMeを返しメソッドチェーン可能 | E-03, E-04, E-14, E-16, E-17 | ○ |
| C-22 | デフォルトFillCharacterはスペース | E-02, E-21 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全ての主張はソースコードにより裏付けられている。

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：全ての機能仕様がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] StringBuilder.clsの行番号が正確か確認
- [ ] EnsureCapacityのバッファ拡張ロジック（2倍または要求量）が正確か確認
- [ ] AppendFormatの書式文字列パースが正しく動作するか確認
- [ ] Replaceの同長/縮小/拡大置換が正しく動作するか確認
- [ ] Insertの後方シフト処理が正確か確認
