---
generated_at: 2026-01-20 18:20:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：機能設計書 49-RijndaelManaged

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  1. なし（全ての主張にソースコードによる根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/CorLib/System.Security.Cryptography/RijndaelManaged.cls` 38-43行目 - クラスコメント（概要説明）
- E-02: `Source/CorLib/System.Security.Cryptography/RijndaelManaged.cls` 49-57行目 - 定数定義（ブロックサイズ/キーサイズ）
- E-03: `Source/CorLib/System.Security.Cryptography/RijndaelManaged.cls` 59行目 - mBase変数（SymmetricAlgorithmBase）
- E-04: `Source/CorLib/System.Security.Cryptography/RijndaelManaged.cls` 69-81行目 - BlockSizeプロパティ
- E-05: `Source/CorLib/System.Security.Cryptography/RijndaelManaged.cls` 117-129行目 - KeySizeプロパティ
- E-06: `Source/CorLib/System.Security.Cryptography/RijndaelManaged.cls` 146-157行目 - Modeプロパティ
- E-07: `Source/CorLib/System.Security.Cryptography/RijndaelManaged.cls` 164-175行目 - Paddingプロパティ
- E-08: `Source/CorLib/System.Security.Cryptography/RijndaelManaged.cls` 183-196行目 - Keyプロパティ
- E-09: `Source/CorLib/System.Security.Cryptography/RijndaelManaged.cls` 211-223行目 - IVプロパティ
- E-10: `Source/CorLib/System.Security.Cryptography/RijndaelManaged.cls` 260-262行目 - CreateEncryptorメソッド
- E-11: `Source/CorLib/System.Security.Cryptography/RijndaelManaged.cls` 274-276行目 - CreateDecryptorメソッド
- E-12: `Source/CorLib/System.Security.Cryptography/RijndaelManaged.cls` 317-323行目 - CreateCipherメソッド
- E-13: `Source/CorLib/System.Security.Cryptography/RijndaelManaged.cls` 329-340行目 - Class_Initialize
- E-14: `Source/CorLib/System.Security.Cryptography/RijndaelManagedTransform.cls` 263-299行目 - Initメソッド
- E-15: `Source/CorLib/System.Security.Cryptography/RijndaelManagedTransform.cls` 267-268行目 - CTS/OFBモード例外
- E-16: `Source/CorLib/System.Security.Cryptography/RijndaelManagedTransform.cls` 501-511行目 - EncryptECBメソッド
- E-17: `Source/CorLib/System.Security.Cryptography/RijndaelManagedTransform.cls` 517-535行目 - EncryptCBCメソッド
- E-18: `Source/CorLib/System.Security.Cryptography/RijndaelManagedTransform.cls` 541-568行目 - EncryptCFBメソッド
- E-19: `Source/CorLib/System.Security.Cryptography/RijndaelManagedTransform.cls` 645-675行目 - Encrypt128メソッド
- E-20: `Source/CorLib/System.Security.Cryptography/RijndaelManagedTransform.cls` 873-895行目 - CreateExpandedKeyメソッド
- E-21: `Source/CorLib/System.Security.Cryptography/RijndaelManagedTransform.cls` 897-905行目 - CalculateNumberOfRoundsメソッド
- E-22: `Source/CorLib/System.Security.Cryptography/SymmetricAlgorithmBase.cls` 282-288行目 - GetKeyメソッド
- E-23: `Source/CorLib/System.Security.Cryptography/SymmetricAlgorithmBase.cls` 243-249行目 - GetIVメソッド
- E-24: `docs/code-to-docs/機能一覧/機能一覧.csv` 50行目 - 機能一覧での定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | RijndaelManagedはRijndael対称ブロック暗号のマネージド実装 | E-01 | ○ |
| C-02 | ブロックサイズは128/192/256ビットをサポート | E-02, E-13 | ○ |
| C-03 | キーサイズは128/192/256ビットをサポート | E-02, E-13 | ○ |
| C-04 | デフォルトBlockSizeは128ビット | E-02, E-13 | ○ |
| C-05 | デフォルトKeySizeは256ビット | E-02, E-13 | ○ |
| C-06 | デフォルトModeはCBC | E-13 | ○ |
| C-07 | デフォルトPaddingはPKCS7 | E-13 | ○ |
| C-08 | BlockSizeプロパティでブロックサイズを取得/設定 | E-04 | ○ |
| C-09 | KeySizeプロパティでキーサイズを取得/設定 | E-05 | ○ |
| C-10 | Modeプロパティで暗号モードを取得/設定 | E-06 | ○ |
| C-11 | Paddingプロパティでパディングモードを取得/設定 | E-07 | ○ |
| C-12 | Keyプロパティで秘密鍵を取得/設定 | E-08, E-22 | ○ |
| C-13 | IVプロパティで初期化ベクトルを取得/設定 | E-09, E-23 | ○ |
| C-14 | Key/IVが未設定の場合はランダム生成 | E-22, E-23 | ○ |
| C-15 | CreateEncryptorで暗号化トランスフォーマを生成 | E-10, E-12 | ○ |
| C-16 | CreateDecryptorで復号化トランスフォーマを生成 | E-11, E-12 | ○ |
| C-17 | RgbKeyとRgbIVの片方のみ指定は例外 | E-12 | ○ |
| C-18 | CTS/OFBモードは例外をスロー | E-15 | ○ |
| C-19 | ECB/CBC/CFBモードをサポート | E-16, E-17, E-18 | ○ |
| C-20 | 128/192/256ビット各ブロックサイズに対応した暗号化関数 | E-16, E-19 | ○ |
| C-21 | ラウンド数はキー/ブロックサイズに基づき10/12/14 | E-21 | ○ |
| C-22 | 拡張鍵を生成して暗号化に使用 | E-20 | ○ |
| C-23 | RijndaelManagedTransformが実際の暗号化/復号化を実行 | E-14 | ○ |
| C-24 | SymmetricAlgorithmBaseに機能を委譲 | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全ての主張はソースコードにより裏付けられている。

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：全ての機能仕様がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] RijndaelManaged.clsの行番号が正確か確認
- [ ] RijndaelManagedTransform.clsの行番号が正確か確認
- [ ] ブロックサイズ/キーサイズの範囲（128-256、64刻み）が正確か確認
- [ ] ラウンド数計算ロジック（10/12/14）が正確か確認
- [ ] CTS/OFBモードで正しく例外がスローされるか確認
- [ ] 暗号化/復号化処理が各モード（ECB/CBC/CFB）で正しく動作するか確認
