---
generated_at: 2026-01-20 11:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：5-TimeZone.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **TimeZoneStaticの詳細実装**：別ファイルのため未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/CorLib/System/TimeZone.cls` 38-42行目（モジュールコメント）
- E-02: `Source/CorLib/System/TimeZone.cls` 44行目（IObject実装）
- E-03: `Source/CorLib/System/TimeZone.cls` 46-54行目（内部変数定義）
- E-04: `Source/CorLib/System/TimeZone.cls` 60-62行目（DaylightNameプロパティ）
- E-05: `Source/CorLib/System/TimeZone.cls` 68-70行目（StandardNameプロパティ）
- E-06: `Source/CorLib/System/TimeZone.cls` 77-79行目（GetDayLightChangesメソッド）
- E-07: `Source/CorLib/System/TimeZone.cls` 86-92行目（GetUtcOffsetメソッド）
- E-08: `Source/CorLib/System/TimeZone.cls` 99-105行目（IsDaylightSavingTimeメソッド）
- E-09: `Source/CorLib/System/TimeZone.cls` 112-122行目（ToLocalTimeメソッド）
- E-10: `Source/CorLib/System/TimeZone.cls` 129-139行目（ToUniversalTimeメソッド）
- E-11: `Source/CorLib/System/TimeZone.cls` 171-184行目（Class_Initialize）
- E-12: `Source/CorLib/System/TimeZone.cls` 190-201行目（GetDaylightTimesメソッド）
- E-13: `Source/CorLib/System/TimeZone.cls` 203-237行目（GetCrossOverPointメソッド）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | タイムゾーン情報を提供 | E-01 | ○ |
| C-02 | IObjectインターフェースを実装 | E-02 | ○ |
| C-03 | TIME_ZONE_INFORMATION構造体を使用 | E-03 | ○ |
| C-04 | DaylightNameプロパティ | E-04 | ○ |
| C-05 | StandardNameプロパティ | E-05 | ○ |
| C-06 | GetDayLightChangesは夏時間期間を返す | E-06 | ○ |
| C-07 | GetUtcOffsetは夏時間を考慮 | E-07 | ○ |
| C-08 | IsDaylightSavingTimeは夏時間判定 | E-08 | ○ |
| C-09 | ToLocalTimeはLocalKindを設定 | E-09 | ○ |
| C-10 | ToUniversalTimeはUtcKindを設定 | E-10 | ○ |
| C-11 | GetTimeZoneInformation APIを使用 | E-11 | ○ |
| C-12 | UTCオフセットはBias+StandardBias/DaylightBias | E-11 | ○ |
| C-13 | 夏時間未使用時はMinValueで初期化 | E-11 | ○ |
| C-14 | GetDaylightTimesで夏時間期間を算出 | E-12 | ○ |
| C-15 | GetCrossOverPointで切り替え日を算出 | E-13 | ○ |
| C-16 | wDay=5は月末週の指定曜日 | E-13 | ○ |
| C-17 | wDay=1-4は第n週の指定曜日 | E-13 | ○ |
| C-18 | TimeZoneStaticの詳細実装 | **別ファイル未確認** | △ |

## 4) 不足情報（Unknown / Missing）
- TimeZoneStaticクラスの詳細実装
  - 候補：`Source/CorLib/System/TimeZoneStatic.cls` の確認が必要

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - TimeZoneクラス自体の実装は完全に確認済み
- 1: 中リスク - システムのタイムゾーン設定に依存するため環境差異あり

## 6) レビュアーチェックリスト（最小）
- [ ] TimeZoneStaticの実装確認（CurrentTimeZone等）
- [ ] DayLightTimeクラスの実装確認
- [ ] 夏時間切り替え日算出ロジックの正確性確認
