---
generated_at: 2026-01-20 18:25:00
metrics:
  claims_total: 26
  claims_with_evidence: 26
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：機能設計書 50-DESCryptoServiceProvider

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：26 / 26、根拠なし：0
- 優先レビュー（高）
  1. なし（全ての主張にソースコードによる根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/CorLib/System.Security.Cryptography/DESCryptoServiceProvider.cls` 38-43行目 - クラスコメント（概要説明）
- E-02: `Source/CorLib/System.Security.Cryptography/DESCryptoServiceProvider.cls` 49-51行目 - 定数定義（ブロックサイズ/キーサイズ/フィードバックサイズ）
- E-03: `Source/CorLib/System.Security.Cryptography/DESCryptoServiceProvider.cls` 53行目 - mBase変数（WithEvents）
- E-04: `Source/CorLib/System.Security.Cryptography/DESCryptoServiceProvider.cls` 63-75行目 - BlockSizeプロパティ
- E-05: `Source/CorLib/System.Security.Cryptography/DESCryptoServiceProvider.cls` 110-122行目 - KeySizeプロパティ
- E-06: `Source/CorLib/System.Security.Cryptography/DESCryptoServiceProvider.cls` 138-149行目 - Modeプロパティ
- E-07: `Source/CorLib/System.Security.Cryptography/DESCryptoServiceProvider.cls` 156-167行目 - Paddingプロパティ
- E-08: `Source/CorLib/System.Security.Cryptography/DESCryptoServiceProvider.cls` 175-187行目 - Keyプロパティ
- E-09: `Source/CorLib/System.Security.Cryptography/DESCryptoServiceProvider.cls` 202-214行目 - IVプロパティ
- E-10: `Source/CorLib/System.Security.Cryptography/DESCryptoServiceProvider.cls` 250-252行目 - CreateEncryptorメソッド
- E-11: `Source/CorLib/System.Security.Cryptography/DESCryptoServiceProvider.cls` 263-265行目 - CreateDecryptorメソッド
- E-12: `Source/CorLib/System.Security.Cryptography/DESCryptoServiceProvider.cls` 306-320行目 - CreateCipherメソッド
- E-13: `Source/CorLib/System.Security.Cryptography/DESCryptoServiceProvider.cls` 315-316行目 - CFB FeedbackSizeチェック
- E-14: `Source/CorLib/System.Security.Cryptography/DESCryptoServiceProvider.cls` 326-340行目 - Class_Initialize
- E-15: `Source/CorLib/System.Security.Cryptography/DESCryptoServiceProvider.cls` 327-328行目 - CryptoAPIサポート確認
- E-16: `Source/CorLib/System.Security.Cryptography/DESCryptoServiceProvider.cls` 466-474行目 - mBase_CheckForWeakKeyイベント
- E-17: `Source/CorLib/System.Security.Cryptography/DESCryptoServiceProvider.cls` 468-471行目 - IsWeakKey/IsSemiWeakKeyチェック
- E-18: `Source/CorLib/System.Security.Cryptography/CryptoAPITransform.cls` 204-233行目 - Initメソッド
- E-19: `Source/CorLib/System.Security.Cryptography/CryptoAPITransform.cls` 206-207行目 - OFBモード例外
- E-20: `Source/CorLib/System.Security.Cryptography/CryptoAPITransform.cls` 209行目 - CryptoAPI鍵インポート
- E-21: `Source/CorLib/System.Security.Cryptography/CryptoAPITransform.cls` 132-146行目 - TransformBlockメソッド
- E-22: `Source/CorLib/System.Security.Cryptography/CryptoAPITransform.cls` 156-164行目 - TransformFinalBlockメソッド
- E-23: `Source/CorLib/System.Security.Cryptography/CryptoAPITransform.cls` 298-307行目 - EncryptBlockメソッド（CryptEncrypt呼び出し）
- E-24: `Source/CorLib/System.Security.Cryptography/CryptoAPITransform.cls` 313-353行目 - DecryptBlockメソッド（CryptDecrypt呼び出し）
- E-25: `Source/CorLib/System.Security.Cryptography/SymmetricAlgorithmBase.cls` 320-330行目 - GenerateKeyメソッド（弱い鍵再生成）
- E-26: `docs/code-to-docs/機能一覧/機能一覧.csv` 51行目 - 機能一覧での定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DESCryptoServiceProviderはWindows CryptoAPIを利用したDES暗号化ラッパー | E-01, E-18 | ○ |
| C-02 | ブロックサイズは64ビット固定 | E-02, E-14 | ○ |
| C-03 | キーサイズは64ビット固定 | E-02, E-14 | ○ |
| C-04 | デフォルトFeedbackSizeは8ビット | E-02, E-14 | ○ |
| C-05 | デフォルトModeはCBC | E-14 | ○ |
| C-06 | デフォルトPaddingはPKCS7 | E-14 | ○ |
| C-07 | BlockSizeプロパティでブロックサイズを取得/設定 | E-04 | ○ |
| C-08 | KeySizeプロパティでキーサイズを取得/設定 | E-05 | ○ |
| C-09 | Modeプロパティで暗号モードを取得/設定 | E-06 | ○ |
| C-10 | Paddingプロパティでパディングモードを取得/設定 | E-07 | ○ |
| C-11 | Keyプロパティで秘密鍵を取得/設定 | E-08 | ○ |
| C-12 | IVプロパティで初期化ベクトルを取得/設定 | E-09 | ○ |
| C-13 | CreateEncryptorで暗号化トランスフォーマを生成 | E-10, E-12 | ○ |
| C-14 | CreateDecryptorで復号化トランスフォーマを生成 | E-11, E-12 | ○ |
| C-15 | CFBモードでFeedbackSize!=8の場合は例外 | E-13 | ○ |
| C-16 | OFBモードは例外をスロー | E-19 | ○ |
| C-17 | 初期化時にCryptoAPIでDESサポート確認 | E-15 | ○ |
| C-18 | CryptoAPIでDES未サポート時は例外 | E-15 | ○ |
| C-19 | 弱い鍵（Weak Key）は拒否される | E-16, E-17 | ○ |
| C-20 | 準弱い鍵（Semi-Weak Key）は拒否される | E-16, E-17 | ○ |
| C-21 | CheckForWeakKeyイベントで鍵を検証 | E-16, E-25 | ○ |
| C-22 | CryptoAPITransformが実際の暗号化/復号化を実行 | E-18, E-21, E-22 | ○ |
| C-23 | CryptEncryptで暗号化実行 | E-23 | ○ |
| C-24 | CryptDecryptで復号化実行 | E-24 | ○ |
| C-25 | SymmetricAlgorithmBaseに機能を委譲 | E-03 | ○ |
| C-26 | GenerateKeyは弱い鍵の場合再生成 | E-25 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全ての主張はソースコードにより裏付けられている。

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：全ての機能仕様がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] DESCryptoServiceProvider.clsの行番号が正確か確認
- [ ] CryptoAPITransform.clsの行番号が正確か確認
- [ ] ブロックサイズ/キーサイズが64ビット固定であることを確認
- [ ] CFBモードでFeedbackSize!=8の場合に例外がスローされるか確認
- [ ] OFBモードで例外がスローされるか確認
- [ ] 弱い鍵/準弱い鍵のチェックが正しく動作するか確認
- [ ] CryptoAPIサポート確認が正しく動作するか確認
