---
generated_at: 2026-01-20 16:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：51-TripleDESCryptoServiceProvider

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **金融機関での使用シーン**：一般的知識に基づく記載
  2. **AESへの移行推奨**：一般的なセキュリティガイドラインに基づく

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/CorLib/System.Security.Cryptography/TripleDESCryptoServiceProvider.cls`
- E-02: `Source/CorLib/System.Security.Cryptography/TripleDES.cls`
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ブロックサイズは64ビット | E-01 (48行目: LegalBlockSize = 64) | ○ |
| C-02 | 鍵サイズは128または192ビット | E-01 (49-50行目: LegalMinKeySize=128, LegalMaxKeySize=192) | ○ |
| C-03 | デフォルト鍵サイズは192ビット | E-01 (51行目: DefaultKeySize = LegalMaxKeySize) | ○ |
| C-04 | SymmetricAlgorithmインターフェース実装 | E-01 (45行目: Implements SymmetricAlgorithm) | ○ |
| C-05 | TripleDESインターフェース実装 | E-01 (46行目: Implements TripleDES) | ○ |
| C-06 | 弱い鍵チェックを実行 | E-01 (380-384行目: mBase_CheckForWeakKey) | ○ |
| C-07 | CALG_3DES_112は128ビット鍵用 | E-01 (333-334行目) | ○ |
| C-08 | CALG_3DESは192ビット鍵用 | E-01 (335-336行目) | ○ |
| C-09 | CFBモードでフィードバックサイズは8固定 | E-01 (329-330行目) | ○ |
| C-10 | CreateEncryptorメソッドが存在 | E-01 (264-266行目) | ○ |
| C-11 | CreateDecryptorメソッドが存在 | E-01 (277-279行目) | ○ |
| C-12 | デフォルトモードはCBC | E-01 (355行目: .Mode = CipherMode.CBC) | ○ |
| C-13 | デフォルトパディングはPKCS7 | E-01 (356行目: .Padding = PaddingMode.PKCS7) | ○ |
| C-14 | 画面No.1で使用 | E-03 (27行目) | ○ |
| C-15 | 画面No.7で使用 | E-03 (65行目) | ○ |
| C-16 | 機能説明はTriple DES暗号化/復号化 | E-04 (51行目) | ○ |
| C-17 | 金融機関での広い使用 | **根拠なし** | △ |
| C-18 | AESへの移行推奨 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-17とC-18は一般的な暗号技術の知識に基づいており、プロジェクト固有の根拠はない
  - 候補：NISTガイドライン / 暗号技術の標準ドキュメント / 業界ベストプラクティス

## 5) リスクフラグ（レビュー観点）
- リスク0（低）: 技術的な仕様についてはソースコードから確認可能
- リスク1（中）: 業務上の目的・背景は一般的知識に依存

## 6) レビュアーチェックリスト（最小）
- [ ] ブロックサイズ64ビットの記載がソースと一致するか確認
- [ ] 鍵サイズ範囲（128-192ビット）の記載がソースと一致するか確認
- [ ] 弱い鍵チェックロジックの説明が正確か確認
- [ ] 関連画面の記載がマッピングCSVと一致するか確認
- [ ] 業務上の目的・背景が組織の認識と合致するか確認
