---
generated_at: 2026-01-20 16:35:00
metrics:
  claims_total: 16
  claims_with_evidence: 14
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：52-RC2CryptoServiceProvider

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：14 / 16、根拠なし：2
- 優先レビュー（高）
  1. **S/MIMEでの使用履歴**：一般的知識に基づく記載
  2. **AES使用推奨**：一般的なセキュリティガイドラインに基づく

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/CorLib/System.Security.Cryptography/RC2CryptoServiceProvider.cls`
- E-02: `Source/CorLib/System.Security.Cryptography/RC2.cls`
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ブロックサイズは64ビット | E-01 (46行目: LegalBlockSize = 64) | ○ |
| C-02 | 鍵サイズは40〜128ビット | E-01 (49-50行目) | ○ |
| C-03 | デフォルト鍵サイズは128ビット | E-01 (51行目) | ○ |
| C-04 | SymmetricAlgorithmインターフェース実装 | E-01 (43行目) | ○ |
| C-05 | RC2インターフェース実装 | E-01 (44行目) | ○ |
| C-06 | EffectiveKeySizeプロパティが存在 | E-01 (71-83行目) | ○ |
| C-07 | CALG_RC2アルゴリズム使用 | E-01 (275行目) | ○ |
| C-08 | UseSaltプロパティが存在 | E-01 (62-68行目) | ○ |
| C-09 | CFBモードでフィードバックサイズは8固定 | E-01 (273行目) | ○ |
| C-10 | CreateEncryptorメソッドが存在 | E-01 (209-211行目) | ○ |
| C-11 | CreateDecryptorメソッドが存在 | E-01 (222-224行目) | ○ |
| C-12 | 画面No.1で使用 | E-03 (28行目) | ○ |
| C-13 | 画面No.7で使用 | E-03 (66行目) | ○ |
| C-14 | 機能説明はRC2暗号化/復号化 | E-04 (52行目) | ○ |
| C-15 | S/MIMEでの使用履歴 | **根拠なし** | △ |
| C-16 | AES使用推奨 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-15とC-16は一般的な暗号技術の知識に基づいており、プロジェクト固有の根拠はない
  - 候補：RFC文書 / 暗号技術の標準ドキュメント / 業界ベストプラクティス

## 5) リスクフラグ（レビュー観点）
- リスク0（低）: 技術的な仕様についてはソースコードから確認可能
- リスク1（中）: 業務上の目的・背景は一般的知識に依存

## 6) レビュアーチェックリスト（最小）
- [ ] ブロックサイズ64ビットの記載がソースと一致するか確認
- [ ] 鍵サイズ範囲（40-128ビット）の記載がソースと一致するか確認
- [ ] EffectiveKeySizeの仕様が正確か確認
- [ ] 関連画面の記載がマッピングCSVと一致するか確認
- [ ] UseSaltプロパティの動作説明が正確か確認
