---
generated_at: 2026-01-20 16:40:00
metrics:
  claims_total: 18
  claims_with_evidence: 15
  claims_without_evidence: 3
confidence_derived: 0.83
---

# 根拠レポート：53-RSACryptoServiceProvider

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.83**
  - 根拠あり：15 / 18、根拠なし：3
- 優先レビュー（高）
  1. **鍵サイズ384-16384ビット範囲**：CSP依存の可能性
  2. **OAEPパディング計算式**：一般的知識に基づく
  3. **2048ビット推奨**：セキュリティガイドラインに基づく

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/CorLib/System.Security.Cryptography/RSACryptoServiceProvider.cls`
- E-02: `Source/CorLib/System.Security.Cryptography/RSA.cls`
- E-03: `Source/CorLib/System.Security.Cryptography/RSAParameters.cls`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | RSAインターフェース実装 | E-01 (Implements RSA) | ○ |
| C-02 | AsymmetricAlgorithmインターフェース実装 | E-01 (Implements AsymmetricAlgorithm) | ○ |
| C-03 | Encryptメソッドが存在 | E-01 | ○ |
| C-04 | Decryptメソッドが存在 | E-01 | ○ |
| C-05 | SignHashメソッドが存在 | E-01 | ○ |
| C-06 | VerifyHashメソッドが存在 | E-01 | ○ |
| C-07 | ExportParametersメソッドが存在 | E-01 | ○ |
| C-08 | ImportParametersメソッドが存在 | E-01 | ○ |
| C-09 | fOAEPパラメータでパディング選択 | E-01 | ○ |
| C-10 | RSAParametersに公開鍵/秘密鍵パラメータ | E-03 | ○ |
| C-11 | PersistKeyInCspプロパティが存在 | E-01 | ○ |
| C-12 | CspParametersで設定可能 | E-01 | ○ |
| C-13 | 画面No.1で使用 | E-04 (29行目) | ○ |
| C-14 | 機能説明はRSA非対称暗号化 | E-05 (53行目) | ○ |
| C-15 | XML形式での鍵エクスポート対応 | E-01 (ToXmlString/FromXmlString) | ○ |
| C-16 | 鍵サイズ範囲384-16384ビット | **根拠なし（CSP依存）** | △ |
| C-17 | OAEPで鍵サイズ-42バイトが最大 | **根拠なし（一般知識）** | △ |
| C-18 | 2048ビット以上推奨 | **根拠なし（ガイドライン）** | △ |

## 4) 不足情報（Unknown / Missing）
- C-16: 鍵サイズ範囲はCSP（Cryptographic Service Provider）に依存するため、実際の制限はCSPごとに異なる可能性がある
- C-17, C-18: 一般的な暗号技術のベストプラクティスに基づいており、プロジェクト固有の根拠はない
  - 候補：NIST SP 800-57 / Microsoft CryptoAPIドキュメント

## 5) リスクフラグ（レビュー観点）
- リスク0（低）: APIの存在・シグネチャについてはソースコードから確認可能
- リスク1（中）: 鍵サイズ制限はCSP依存
- リスク1（中）: セキュリティ推奨事項は外部ガイドラインに依存

## 6) レビュアーチェックリスト（最小）
- [ ] Encrypt/Decrypt/SignHash/VerifyHashの各メソッドがソースに存在するか確認
- [ ] RSAParametersの構造がドキュメントと一致するか確認
- [ ] 関連画面の記載がマッピングCSVと一致するか確認
- [ ] 鍵サイズ制限の実際の挙動を検証（CSP依存性の確認）
- [ ] OAEPパディングのデータサイズ制限が正確か確認
