---
generated_at: 2026-01-20 16:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 13
  claims_without_evidence: 3
confidence_derived: 0.81
---

# 根拠レポート：54-DSACryptoServiceProvider

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.81**
  - 根拠あり：13 / 16、根拠なし：3
- 優先レビュー（高）
  1. **鍵サイズ512-1024ビット範囲**：CSP依存の可能性
  2. **SHA-1のみサポート**：DSA-2拡張未確認
  3. **署名サイズ40バイト固定**：FIPS 186準拠確認要

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/CorLib/System.Security.Cryptography/DSACryptoServiceProvider.cls`
- E-02: `Source/CorLib/System.Security.Cryptography/DSA.cls`
- E-03: `Source/CorLib/System.Security.Cryptography/DSAParameters.cls`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DSAインターフェース実装 | E-01 (Implements DSA) | ○ |
| C-02 | AsymmetricAlgorithmインターフェース実装 | E-01 (Implements AsymmetricAlgorithm) | ○ |
| C-03 | SignHashメソッドが存在 | E-01 | ○ |
| C-04 | VerifyHashメソッドが存在 | E-01 | ○ |
| C-05 | SignDataメソッドが存在 | E-01 | ○ |
| C-06 | VerifyDataメソッドが存在 | E-01 | ○ |
| C-07 | ExportParametersメソッドが存在 | E-01 | ○ |
| C-08 | ImportParametersメソッドが存在 | E-01 | ○ |
| C-09 | DSAParametersに公開鍵/秘密鍵パラメータ | E-03 | ○ |
| C-10 | PersistKeyInCspプロパティが存在 | E-01 | ○ |
| C-11 | 画面No.1で使用 | E-04 (30行目) | ○ |
| C-12 | 機能説明はDSAデジタル署名 | E-05 (54行目) | ○ |
| C-13 | XML形式での鍵エクスポート対応 | E-01 (ToXmlString/FromXmlString) | ○ |
| C-14 | 鍵サイズ範囲512-1024ビット | **根拠なし（CSP依存）** | △ |
| C-15 | SHA-1のみサポート | **根拠なし（DSA-2未確認）** | △ |
| C-16 | 署名サイズ40バイト固定 | **根拠なし（FIPS準拠確認要）** | △ |

## 4) 不足情報（Unknown / Missing）
- C-14: 鍵サイズ範囲はCSP（Cryptographic Service Provider）に依存するため確認が必要
- C-15: FIPS 186-3以降のDSA-2ではSHA-256等もサポートされるが、本実装での対応状況は未確認
- C-16: 署名形式（IEEE P1363 vs ASN.1 DER）によりサイズが異なる可能性
  - 候補：FIPS 186-4 / Microsoft CryptoAPIドキュメント

## 5) リスクフラグ（レビュー観点）
- リスク0（低）: APIの存在・シグネチャについてはソースコードから確認可能
- リスク1（中）: 鍵サイズ制限とハッシュアルゴリズム対応はCSP依存
- リスク2（高）: SHA-1の脆弱性に関する注意喚起が必要

## 6) レビュアーチェックリスト（最小）
- [ ] SignHash/VerifyHash/SignData/VerifyDataの各メソッドがソースに存在するか確認
- [ ] DSAParametersの構造がドキュメントと一致するか確認
- [ ] 関連画面の記載がマッピングCSVと一致するか確認
- [ ] 鍵サイズ制限の実際の挙動を検証（CSP依存性の確認）
- [ ] SHA-1以外のハッシュアルゴリズム対応状況を確認
