---
generated_at: 2026-01-20 16:50:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：55-SHA1Managed

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **SHA-1衝突攻撃の脆弱性**：一般的セキュリティ知識に基づく

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/CorLib/System.Security.Cryptography/SHA1Managed.cls`
- E-02: `Source/CorLib/System.Security.Cryptography/SHA1.cls`
- E-03: `Source/CorLib/System.Security.Cryptography/HashAlgorithmBase.cls`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HashAlgorithmインターフェース実装 | E-01 (50行目: Implements HashAlgorithm) | ○ |
| C-02 | SHA1インターフェース実装 | E-01 (51行目: Implements SHA1) | ○ |
| C-03 | ICryptoTransformインターフェース実装 | E-01 (52行目: Implements ICryptoTransform) | ○ |
| C-04 | ハッシュサイズ160ビット | E-01 (95-97行目: HashSize = 160) | ○ |
| C-05 | 初期ハッシュ値H0=0x67452301 | E-01 (145行目: mState(0) = &H67452301) | ○ |
| C-06 | 初期ハッシュ値H1=0xEFCDAB89 | E-01 (146行目: mState(1) = &HEFCDAB89) | ○ |
| C-07 | 初期ハッシュ値H2=0x98BADCFE | E-01 (147行目: mState(2) = &H98BADCFE) | ○ |
| C-08 | 初期ハッシュ値H3=0x10325476 | E-01 (148行目: mState(3) = &H10325476) | ○ |
| C-09 | 初期ハッシュ値H4=0xC3D2E1F0 | E-01 (149行目: mState(4) = &HC3D2E1F0) | ○ |
| C-10 | ラウンド定数K0-19=0x5A827999 | E-01 (286行目, 358行目) | ○ |
| C-11 | ラウンド定数K20-39=0x6ED9EBA1 | E-01 (295行目, 361行目) | ○ |
| C-12 | ラウンド定数K40-59=0x8F1BBCDC | E-01 (304行目, 364行目) | ○ |
| C-13 | ラウンド定数K60-79=0xCA62C1D6 | E-01 (313行目, 367行目) | ○ |
| C-14 | CanReuseTransformはTrue | E-01 (66-68行目) | ○ |
| C-15 | CanTransformMultipleBlocksはTrue | E-01 (74-76行目) | ○ |
| C-16 | 画面No.1で使用 | E-04 (31行目) | ○ |
| C-17 | 機能説明はSHA-1ハッシュアルゴリズム | E-05 (55行目) | ○ |
| C-18 | SHA-1は衝突攻撃に脆弱 | **根拠なし（一般知識）** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18: SHA-1の脆弱性に関する記載は一般的なセキュリティ知識に基づいており、プロジェクト固有の根拠はない
  - 候補：NIST推奨事項 / SHAttered攻撃論文 / セキュリティガイドライン

## 5) リスクフラグ（レビュー観点）
- リスク0（低）: 技術的な仕様についてはソースコードから確認可能
- リスク0（低）: 初期値・定数についてはFIPS 180-4準拠を確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] HashSize=160の記載がソースと一致するか確認
- [ ] 初期ハッシュ値5つがソースと一致するか確認
- [ ] ラウンド定数4つがソースと一致するか確認
- [ ] 関連画面の記載がマッピングCSVと一致するか確認
- [ ] Transform処理の80ラウンド構造が正しいか確認
