---
generated_at: 2026-01-20 16:55:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：56-SHA256Managed

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **量子コンピュータ耐性の限定性**：一般的セキュリティ知識に基づく

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/CorLib/System.Security.Cryptography/SHA256Managed.cls`
- E-02: `Source/CorLib/System.Security.Cryptography/SHA256.cls`
- E-03: `Source/CorLib/System.Security.Cryptography/HashAlgorithmBase.cls`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HashAlgorithmインターフェース実装 | E-01 (47行目: Implements HashAlgorithm) | ○ |
| C-02 | SHA256インターフェース実装 | E-01 (49行目: Implements SHA256) | ○ |
| C-03 | ICryptoTransformインターフェース実装 | E-01 (48行目: Implements ICryptoTransform) | ○ |
| C-04 | ハッシュサイズ256ビット | E-01 (93-95行目: HashSize = 256) | ○ |
| C-05 | 初期ハッシュ値H0=0x6A09E667 | E-01 (143行目: mState(0) = &H6A09E667) | ○ |
| C-06 | 初期ハッシュ値H1=0xBB67AE85 | E-01 (144行目: mState(1) = &HBB67AE85) | ○ |
| C-07 | 初期ハッシュ値H2=0x3C6EF372 | E-01 (145行目: mState(2) = &H3C6EF372) | ○ |
| C-08 | 初期ハッシュ値H3=0xA54FF53A | E-01 (146行目: mState(3) = &HA54FF53A) | ○ |
| C-09 | 初期ハッシュ値H4=0x510E527F | E-01 (147行目: mState(4) = &H510E527F) | ○ |
| C-10 | 初期ハッシュ値H5=0x9B05688C | E-01 (148行目: mState(5) = &H9B05688C) | ○ |
| C-11 | 初期ハッシュ値H6=0x1F83D9AB | E-01 (149行目: mState(6) = &H1F83D9AB) | ○ |
| C-12 | 初期ハッシュ値H7=0x5BE0CD19 | E-01 (150行目: mState(7) = &H5BE0CD19) | ○ |
| C-13 | CanReuseTransformはTrue | E-01 (64-66行目) | ○ |
| C-14 | 画面No.1で使用 | E-04 (32行目) | ○ |
| C-15 | 機能説明はSHA-256ハッシュアルゴリズム | E-05 (56行目) | ○ |
| C-16 | 量子コンピュータ耐性は限定的 | **根拠なし（一般知識）** | △ |

## 4) 不足情報（Unknown / Missing）
- C-16: 量子コンピュータ耐性に関する記載は一般的なセキュリティ知識に基づいており、プロジェクト固有の根拠はない
  - 候補：NISTポスト量子暗号標準化プロジェクト / Groverアルゴリズム論文

## 5) リスクフラグ（レビュー観点）
- リスク0（低）: 技術的な仕様についてはソースコードから確認可能
- リスク0（低）: 初期値・定数についてはFIPS 180-4準拠を確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] HashSize=256の記載がソースと一致するか確認
- [ ] 初期ハッシュ値8つがソースと一致するか確認
- [ ] 64ラウンド定数がStaticsから正しく読み込まれているか確認
- [ ] 関連画面の記載がマッピングCSVと一致するか確認
- [ ] Transform処理の64ラウンド構造が正しいか確認
