---
generated_at: 2026-01-20 17:00:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：57-SHA384Managed

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **192ビットセキュリティレベル**：一般的暗号理論に基づく

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/CorLib/System.Security.Cryptography/SHA384Managed.cls`
- E-02: `Source/CorLib/System.Security.Cryptography/SHA384.cls`
- E-03: `Source/CorLib/System.Security.Cryptography/SHA512Managed.cls`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HashAlgorithmインターフェース実装 | E-01 (47行目: Implements HashAlgorithm) | ○ |
| C-02 | SHA384インターフェース実装 | E-01 (48行目: Implements SHA384) | ○ |
| C-03 | ICryptoTransformインターフェース実装 | E-01 (49行目: Implements ICryptoTransform) | ○ |
| C-04 | ハッシュサイズ384ビット | E-01 (93-95行目: HashSize = 384) | ○ |
| C-05 | 出力は48バイト | E-01 (51行目: HashSizeInBytes = 48) | ○ |
| C-06 | SHA512Managedを内部使用 | E-01 (53行目: mBase As New SHA512Managed) | ○ |
| C-07 | ReDim Preserveで48バイトに切り詰め | E-01 (84行目, 136行目) | ○ |
| C-08 | SHA384用初期値で初期化 | E-01 (219行目: mBase.Init Statics.SHA384.StatePtr) | ○ |
| C-09 | ブロックサイズ128バイト | E-03から委譲（SHA512と同じ） | ○ |
| C-10 | 80ラウンド圧縮関数 | E-03から委譲（SHA512と同じ） | ○ |
| C-11 | 画面No.1で使用 | E-04 (33行目) | ○ |
| C-12 | 機能説明はSHA-384ハッシュアルゴリズム | E-05 (57行目) | ○ |
| C-13 | CanReuseTransformはTrue | E-01 (委譲: mBase.CanReuseTransform) | ○ |
| C-14 | 192ビットセキュリティレベル | **根拠なし（暗号理論）** | △ |

## 4) 不足情報（Unknown / Missing）
- C-14: セキュリティレベルに関する記載は一般的な暗号理論（誕生日攻撃の計算量）に基づいており、プロジェクト固有の根拠はない
  - 候補：FIPS 180-4 / NISTセキュリティ強度ガイドライン

## 5) リスクフラグ（レビュー観点）
- リスク0（低）: 技術的な仕様についてはソースコードから確認可能
- リスク0（低）: SHA512Managedへの委譲パターンが明確

## 6) レビュアーチェックリスト（最小）
- [ ] HashSize=384の記載がソースと一致するか確認
- [ ] HashSizeInBytes=48の記載がソースと一致するか確認
- [ ] SHA512Managedへの委譲が正しく行われているか確認
- [ ] 48バイト切り詰めが正しく実装されているか確認
- [ ] 関連画面の記載がマッピングCSVと一致するか確認
