---
generated_at: 2026-01-20 17:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：58-SHA512Managed

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **256ビットセキュリティレベル**：一般的暗号理論に基づく

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/CorLib/System.Security.Cryptography/SHA512Managed.cls`
- E-02: `Source/CorLib/System.Security.Cryptography/SHA512.cls`
- E-03: `Source/CorLib/System.Security.Cryptography/HashAlgorithmBase.cls`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HashAlgorithmインターフェース実装 | E-01 (47行目: Implements HashAlgorithm) | ○ |
| C-02 | SHA512インターフェース実装 | E-01 (49行目: Implements SHA512) | ○ |
| C-03 | ICryptoTransformインターフェース実装 | E-01 (48行目: Implements ICryptoTransform) | ○ |
| C-04 | IHashAlgorithmインターフェース実装 | E-01 (50行目: Implements IHashAlgorithm) | ○ |
| C-05 | ハッシュサイズ512ビット | E-01 (96-98行目: HashSize = 512) | ○ |
| C-06 | 64バイトブロック出力 | E-01 (268行目: ReDim Result(0 To 63)) | ○ |
| C-07 | 128バイトブロックサイズ | E-01 (231行目: Set mBase = Cor.NewHashAlgorithmBase(Me, True, True, 128)) | ○ |
| C-08 | 80ラウンド処理 | E-01 (292-334行目: For i = 16 To 79, 358-435行目: For i = 0 To 79) | ○ |
| C-09 | 64ビット演算を32ビットペアで実装 | E-01 (53-58行目: mWh/mWl, mStateH/mStateL) | ○ |
| C-10 | Init Friendメソッドで初期値差し替え | E-01 (235-238行目: Friend Sub Init) | ○ |
| C-11 | UAdd64ヘルパー使用 | E-01 (532-534行目) | ○ |
| C-12 | RRotateHi/Lo関数 | E-01 (550-564行目) | ○ |
| C-13 | BigSIG0/BigSIG1関数 | E-01 (574-588行目) | ○ |
| C-14 | LilSig0/LilSig1関数 | E-01 (590-604行目) | ○ |
| C-15 | Choice/Maj関数 | E-01 (566-572行目) | ○ |
| C-16 | 画面No.1で使用 | E-04 (34行目) | ○ |
| C-17 | 機能説明はSHA-512ハッシュアルゴリズム | E-05 (58行目) | ○ |
| C-18 | 256ビットセキュリティレベル | **根拠なし（暗号理論）** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18: セキュリティレベルに関する記載は一般的な暗号理論（誕生日攻撃の計算量）に基づいており、プロジェクト固有の根拠はない
  - 候補：FIPS 180-4 / NISTセキュリティ強度ガイドライン

## 5) リスクフラグ（レビュー観点）
- リスク0（低）: 技術的な仕様についてはソースコードから確認可能
- リスク0（低）: 64ビット演算エミュレーションは明確に実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] HashSize=512の記載がソースと一致するか確認
- [ ] 128バイトブロックサイズの記載がソースと一致するか確認
- [ ] 80ラウンド処理のループが正しいか確認
- [ ] 64ビットペア演算（mWh/mWl等）が正しく実装されているか確認
- [ ] 関連画面の記載がマッピングCSVと一致するか確認
