---
generated_at: 2026-01-20 17:10:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：59-MD5CryptoServiceProvider

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **MD5衝突攻撃の脆弱性**：一般的セキュリティ知識に基づく

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/CorLib/System.Security.Cryptography/MD5CryptoServiceProvider.cls`
- E-02: `Source/CorLib/System.Security.Cryptography/MD5.cls`
- E-03: `Source/CorLib/System.Security.Cryptography/CryptoAPIHash.cls`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HashAlgorithmインターフェース実装 | E-01 (43行目: Implements HashAlgorithm) | ○ |
| C-02 | MD5インターフェース実装 | E-01 (44行目: Implements MD5) | ○ |
| C-03 | ICryptoTransformインターフェース実装 | E-01 (45行目: Implements ICryptoTransform) | ○ |
| C-04 | ハッシュサイズ128ビット | E-01 (85-87行目: HashSize = 128) | ○ |
| C-05 | 出力は16バイト | E-01 (HashSize / 8 = 16) | ○ |
| C-06 | CryptoAPIHash使用 | E-01 (208行目: Set mCore = Cor.NewCryptoAPIHash(CALG_MD5, Me.HashSize)) | ○ |
| C-07 | CALG_MD5アルゴリズム指定 | E-01 (208行目) | ○ |
| C-08 | CanReuseTransformはTrue | E-01 (56-58行目) | ○ |
| C-09 | CanTransformMultipleBlocksはTrue | E-01 (65-67行目) | ○ |
| C-10 | Initialize実装 | E-01 (131-133行目) | ○ |
| C-11 | ComputeHash実装 | E-01 (124-126行目) | ○ |
| C-12 | 画面No.1で使用 | E-04 (35行目) | ○ |
| C-13 | 機能説明はMD5ハッシュアルゴリズム | E-05 (59行目) | ○ |
| C-14 | MD5は衝突攻撃に脆弱 | **根拠なし（一般知識）** | △ |

## 4) 不足情報（Unknown / Missing）
- C-14: MD5の脆弱性に関する記載は一般的なセキュリティ知識に基づいており、プロジェクト固有の根拠はない
  - 候補：RFC 6151 / MD5衝突攻撃論文（2004年Wang et al.）

## 5) リスクフラグ（レビュー観点）
- リスク0（低）: 技術的な仕様についてはソースコードから確認可能
- リスク2（高）: MD5のセキュリティ脆弱性についてユーザーへの警告が重要

## 6) レビュアーチェックリスト（最小）
- [ ] HashSize=128の記載がソースと一致するか確認
- [ ] CALG_MD5アルゴリズム指定がソースと一致するか確認
- [ ] CryptoAPIHashへの委譲が正しく行われているか確認
- [ ] 関連画面の記載がマッピングCSVと一致するか確認
- [ ] セキュリティ警告が適切に記載されているか確認
