---
generated_at: 2026-01-20 11:35:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：6-Guid.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **GuidStaticの詳細実装**：別ファイルのため未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/CorLib/System/Guid.cls` 38-56行目（モジュールコメント）
- E-02: `Source/CorLib/System/Guid.cls` 58-60行目（インターフェース実装）
- E-03: `Source/CorLib/System/Guid.cls` 74-78行目（FormatOptions列挙型）
- E-04: `Source/CorLib/System/Guid.cls` 80-82行目（内部変数）
- E-05: `Source/CorLib/System/Guid.cls` 95-102行目（Handleプロパティ）
- E-06: `Source/CorLib/System/Guid.cls` 109-111行目（IsReadOnlyプロパティ）
- E-07: `Source/CorLib/System/Guid.cls` 118-123行目（ToByteArrayメソッド）
- E-08: `Source/CorLib/System/Guid.cls` 131-146行目（CompareToメソッド）
- E-09: `Source/CorLib/System/Guid.cls` 164-190行目（ToStringメソッド）
- E-10: `Source/CorLib/System/Guid.cls` 198-206行目（Equalsメソッド）
- E-11: `Source/CorLib/System/Guid.cls` 212-216行目（GetHashCodeメソッド）
- E-12: `Source/CorLib/System/Guid.cls` 223-232行目（InternalCompareメソッド）
- E-13: `Source/CorLib/System/Guid.cls` 238-251行目（Initメソッド）
- E-14: `Source/CorLib/System/Guid.cls` 262-272行目（FromByteArrayメソッド）
- E-15: `Source/CorLib/System/Guid.cls` 274-278行目（Parseメソッド）
- E-16: `Source/CorLib/System/Guid.cls` 309-350行目（ToStandardStringメソッド）
- E-17: `Source/CorLib/System/Guid.cls` 361-395行目（ToHexStringメソッド）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 128ビットの一意識別子を表現 | E-01 | ○ |
| C-02 | IObject、IComparable、IFormattableを実装 | E-02 | ○ |
| C-03 | 書式オプション（None/Dashes/Closure） | E-03 | ○ |
| C-04 | mGuid、mIsReadOnlyで内部状態を管理 | E-04 | ○ |
| C-05 | Handleは構造体へのポインタを返す | E-05 | ○ |
| C-06 | IsReadOnlyで読み取り専用状態を返す | E-06 | ○ |
| C-07 | ToByteArrayは16バイト配列を返す | E-07 | ○ |
| C-08 | CompareToはGuid以外でエラー | E-08 | ○ |
| C-09 | ToStringはD/B/P/N/X形式をサポート | E-09 | ○ |
| C-10 | EqualsはIsEqualGUIDを使用 | E-10 | ○ |
| C-11 | GetHashCodeはXORベース | E-11 | ○ |
| C-12 | InternalCompareはData1→Data2→Data3→Data4の順 | E-12 | ○ |
| C-13 | Initは文字列/バイト配列/ポインタを受け付ける | E-13 | ○ |
| C-14 | FromByteArrayは16バイトを検証 | E-14 | ○ |
| C-15 | ParseはGuid.Parserを使用 | E-15 | ○ |
| C-16 | D形式は00000000-0000-0000-0000-000000000000 | E-16 | ○ |
| C-17 | B形式は中括弧で囲む | E-16 | ○ |
| C-18 | X形式は0x接頭辞付き | E-17 | ○ |
| C-19 | 永続化可能（PropertyBag使用） | E-01 (4行目) | ○ |
| C-20 | GuidStaticの詳細実装 | **別ファイル未確認** | △ |

## 4) 不足情報（Unknown / Missing）
- GuidStaticクラスの詳細実装
  - 候補：`Source/CorLib/System/GuidStatic.cls` の確認が必要
- GuidParserクラスの詳細実装
  - 候補：`Source/CorLib/System/GuidParser.cls` の確認が必要

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Guidクラス自体の実装は完全に確認済み
- 0: 低リスク - 書式変換ロジックは明確

## 6) レビュアーチェックリスト（最小）
- [ ] GuidStaticの実装確認（NewGuid、Parse、Empty等）
- [ ] GuidParserの実装確認（TryParse、ThrowError等）
- [ ] 読み取り専用時のHandle動作確認
