---
generated_at: 2026-01-20 17:15:00
metrics:
  claims_total: 16
  claims_with_evidence: 14
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：60-RIPEMD160Managed

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：14 / 16、根拠なし：2
- 優先レビュー（高）
  1. **Bitcoinでの使用**：一般的知識に基づく
  2. **長期的安全性の不確定性**：暗号研究の一般知識に基づく

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/CorLib/System.Security.Cryptography/RIPEMD160Managed.cls`
- E-02: `Source/CorLib/System.Security.Cryptography/RIPEMD160.cls`
- E-03: `Source/CorLib/System.Security.Cryptography/HashAlgorithmBase.cls`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HashAlgorithmインターフェース実装 | E-01 (45行目: Implements HashAlgorithm) | ○ |
| C-02 | RIPEMD160インターフェース実装 | E-01 (46行目: Implements RIPEMD160) | ○ |
| C-03 | ICryptoTransformインターフェース実装 | E-01 (47行目: Implements ICryptoTransform) | ○ |
| C-04 | IHashAlgorithmインターフェース実装 | E-01 (48行目: Implements IHashAlgorithm) | ○ |
| C-05 | ハッシュサイズ160ビット | E-01 (89-91行目: HashSize = 160) | ○ |
| C-06 | 初期ハッシュ値H0=0x67452301 | E-01 (137行目: mState(0) = &H67452301) | ○ |
| C-07 | 初期ハッシュ値H1=0xEFCDAB89 | E-01 (138行目: mState(1) = &HEFCDAB89) | ○ |
| C-08 | 初期ハッシュ値H2=0x98BADCFE | E-01 (139行目: mState(2) = &H98BADCFE) | ○ |
| C-09 | 初期ハッシュ値H3=0x10325476 | E-01 (140行目: mState(3) = &H10325476) | ○ |
| C-10 | 初期ハッシュ値H4=0xC3D2E1F0 | E-01 (141行目: mState(4) = &HC3D2E1F0) | ○ |
| C-11 | CanReuseTransformはTrue | E-01 (60-62行目) | ○ |
| C-12 | CanTransformMultipleBlocksはTrue | E-01 (69-71行目) | ○ |
| C-13 | 画面No.1で使用 | E-04 (36行目) | ○ |
| C-14 | 機能説明はRIPEMD-160ハッシュアルゴリズム | E-05 (60行目) | ○ |
| C-15 | Bitcoinアドレス生成で使用 | **根拠なし（一般知識）** | △ |
| C-16 | 長期的安全性は不確定 | **根拠なし（暗号研究）** | △ |

## 4) 不足情報（Unknown / Missing）
- C-15: BitcoinでのRIPEMD-160使用は一般的な暗号通貨知識に基づいており、プロジェクト固有の根拠はない
- C-16: 長期的安全性についての記載は暗号研究の一般知識に基づく
  - 候補：Bitcoin技術仕様 / RIPEMD-160公式仕様書

## 5) リスクフラグ（レビュー観点）
- リスク0（低）: 技術的な仕様についてはソースコードから確認可能
- リスク0（低）: 初期値はMD4/MD5と同じであることがソースから確認可能
- リスク1（中）: 並列処理構造の正確性については詳細なコードレビューが必要

## 6) レビュアーチェックリスト（最小）
- [ ] HashSize=160の記載がソースと一致するか確認
- [ ] 初期ハッシュ値5つがソースと一致するか確認
- [ ] 左右並列処理（aa-ee, aaa-eee）が正しく実装されているか確認
- [ ] ブール関数（FF, GG, HH, II, JJ）が仕様通りか確認
- [ ] 関連画面の記載がマッピングCSVと一致するか確認
