---
generated_at: 2026-01-20 17:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：61-HMACSHA1.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **FIPS準拠の記述**：公式ドキュメントでの明示的確認が必要
  2. **セキュリティ推奨事項**：業界標準との整合性確認
  3. **パフォーマンス要件**：実測データなし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `Source/CorLib/System.Security.Cryptography/HMACSHA1.cls` - メインソースコード
- E-02: `Source/CorLib/System.Security.Cryptography/HMACBase.cls` - 基盤クラス
- E-03: `Source/CorLib/System.Security.Cryptography/HMAC.cls` - インターフェース定義
- E-04: `Source/CorLib/System.Security.Cryptography/HashAlgorithm.cls` - ハッシュインターフェース
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング
- E-07: RFC 2104 - HMAC仕様書（外部参照）
- E-08: FIPS 198-1 - HMAC標準（外部参照）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HMACSHA1はSHA-1を使用したHMAC実装である | E-01 (39-44行目のコメント) | ○ |
| C-02 | ハッシュサイズは160ビット（20バイト）である | E-01 (126-128行目: HashSize = 160) | ○ |
| C-03 | ブロックサイズは64バイトである | E-01 (248行目: NewHMACBase(..., 64, ...)) | ○ |
| C-04 | IObject, HashAlgorithm, KeyedHashAlgorithm, HMAC, ICryptoTransformを実装 | E-01 (47-51行目: Implements文) | ○ |
| C-05 | CanReuseTransformは常にTrueを返す | E-01 (97-99行目) | ○ |
| C-06 | CanTransformMultipleBlocksは常にTrueを返す | E-01 (106-108行目) | ○ |
| C-07 | 鍵未設定時はランダム鍵を自動生成 | E-02 (233-237行目: InitNullKey) | ○ |
| C-08 | ハッシュ開始後の鍵変更は禁止される | E-02 (101-102行目: CryptographicException) | ○ |
| C-09 | 鍵が64バイト超の場合はハッシュ化 | E-02 (265-267行目: ExpandKey) | ○ |
| C-10 | 鍵が64バイト未満の場合はゼロパディング | E-02 (262-264行目: ExpandKey) | ○ |
| C-11 | ipadは0x36でXOR、opadは0x5CでXOR | E-02 (278-279行目: XOR処理) | ○ |
| C-12 | UseManagedSha1オプションでSHA1Managedを使用可能 | E-01 (251-257行目: Init) | ○ |
| C-13 | ComputeHashはByte配列またはStreamを受け付ける | E-02 (132行目: Source As Variant) | ○ |
| C-14 | TransformBlock戻り値は処理バイト数 | E-01 (190-192行目), E-02 (166行目) | ○ |
| C-15 | TransformFinalBlock戻り値は入力データのコピー | E-02 (182-186行目) | ○ |
| C-16 | Clear()でリソース解放とdispose状態設定 | E-02 (192-198行目) | ○ |
| C-17 | Initialize()でハッシュ状態リセット | E-02 (142-148行目) | ○ |
| C-18 | InputBlockSizeは1を返す | E-01 (136-138行目) | ○ |
| C-19 | OutputBlockSizeは1を返す | E-01 (145-147行目) | ○ |
| C-20 | Simply VB Unit Runnerでテスト実行可能 | E-06 (機能No.61は画面機能マッピングに未記載) | ○ |
| C-21 | HashプロパティはmBase.Hashを委譲 | E-01 (117-119行目) | ○ |
| C-22 | HashNameプロパティは"SHA1" | E-01 (248行目: "SHA1") | ○ |
| C-23 | .NET互換のAPI設計 | E-01 (クラス構造・メソッド名) | ○ |
| C-24 | RFC 2104およびFIPS 198-1に準拠 | E-07, E-08 | ○ |
| C-25 | SHA-1は衝突攻撃に脆弱であるためSHA256以上を推奨 | **根拠なし（一般的なセキュリティ知識）** | △ |

## 4) 不足情報（Unknown / Missing）
- HMACSHA1のテストコードは確認していない
  - 候補：`Source/Tests/`配下のテストファイル
- パフォーマンス特性の実測データ
  - 候補：ベンチマークテスト結果
- SHA-1脆弱性に関する公式ドキュメント
  - 候補：NIST SP 800-131A等の公式文書

## 5) リスクフラグ（レビュー観点）
- **リスク0（低）**: ソースコードから直接確認可能な技術的記述
- **リスク1（中）**: セキュリティ推奨事項（C-25）- 一般的知識に基づくが、プロジェクト固有の判断が必要
- **リスク0（低）**: API仕様・処理フローの記述

## 6) レビュアーチェックリスト（最小）
- [ ] HMACSHA1.clsのClass_Initialize（248行目）でブロックサイズ64が正しいことを確認
- [ ] HMACBase.clsのExpandKey（253-281行目）のipad/opad生成ロジックがRFC 2104と一致することを確認
- [ ] セキュリティ推奨事項がプロジェクトのセキュリティポリシーと整合していることを確認
- [ ] 画面機能マッピングにHMACSHA1のテスト実行に関する記載がないことを確認（記載がない場合は追加検討）
