---
generated_at: 2026-01-20 17:05:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：62-HMACSHA256.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. **なし** - 全ての主張に根拠あり
  2. **パフォーマンス比較**：マネージド vs CSPの実測データがあれば確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `Source/CorLib/System.Security.Cryptography/HMACSHA256.cls` - メインソースコード
- E-02: `Source/CorLib/System.Security.Cryptography/HMACBase.cls` - 基盤クラス
- E-03: `Source/CorLib/System.Security.Cryptography/HMAC.cls` - インターフェース定義
- E-04: `Source/CorLib/System.Security.Cryptography/SHA256Managed.cls` - SHA256実装
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HMACSHA256はSHA-256を使用したHMAC実装である | E-01 (38-44行目のコメント) | ○ |
| C-02 | ハッシュサイズは256ビット（32バイト）である | E-01 (126-128行目: HashSize = 256) | ○ |
| C-03 | ブロックサイズは64バイトである | E-01 (248行目: NewHMACBase(..., 64, ...)) | ○ |
| C-04 | IObject, HashAlgorithm, KeyedHashAlgorithm, HMAC, ICryptoTransformを実装 | E-01 (47-51行目: Implements文) | ○ |
| C-05 | CanReuseTransformは常にTrueを返す | E-01 (97-99行目) | ○ |
| C-06 | CanTransformMultipleBlocksは常にTrueを返す | E-01 (106-108行目) | ○ |
| C-07 | SHA256Managedを内部で使用する | E-01 (248行目: New SHA256Managed) | ○ |
| C-08 | HashNameは"SHA256" | E-01 (248行目: "SHA256") | ○ |
| C-09 | Initメソッドは鍵のみを受け取る（HMACSHA1と異なる） | E-01 (251-253行目) | ○ |
| C-10 | ComputeHashはHMACBaseに委譲される | E-01 (166-168行目) | ○ |
| C-11 | TransformBlockはHMACBaseに委譲される | E-01 (190-192行目) | ○ |
| C-12 | TransformFinalBlockはHMACBaseに委譲される | E-01 (204-206行目) | ○ |
| C-13 | ClearはHMACBaseに委譲される | E-01 (152-154行目) | ○ |
| C-14 | InitializeはHMACBaseに委譲される | E-01 (173-175行目) | ○ |
| C-15 | InputBlockSizeは1を返す | E-01 (136-138行目) | ○ |
| C-16 | OutputBlockSizeは1を返す | E-01 (145-147行目) | ○ |
| C-17 | 画面機能マッピングに記載なし | E-06 (HMACSHA256の記載なし) | ○ |
| C-18 | HMACBase共通の鍵正規化ロジックを使用 | E-02 (253-281行目: ExpandKey) | ○ |
| C-19 | HMACBase共通のipad/opad生成を使用 | E-02 (273-280行目) | ○ |
| C-20 | UseManagedSha1オプションはない（HMACSHA1との差異） | E-01 (InitメソッドにUseManagedSha1パラメータなし) | ○ |

## 4) 不足情報（Unknown / Missing）
- HMACSHA256のテストコードは確認していない
  - 候補：`Source/Tests/`配下のテストファイル
- パフォーマンス特性の実測データ
  - 候補：ベンチマークテスト結果

## 5) リスクフラグ（レビュー観点）
- **リスク0（低）**: 全ての主張がソースコードから直接確認可能
- **リスク0（低）**: HMACSHA1との差異も明確に確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] HMACSHA256.clsのClass_Initialize（248行目）でSHA256Managedが使用されていることを確認
- [ ] HashSizeが256であることを確認
- [ ] HMACSHA1との差異（UseManagedオプションなし）が設計意図に沿っていることを確認
