---
generated_at: 2026-01-20 17:15:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：64-HMACSHA512.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. **なし** - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/CorLib/System.Security.Cryptography/HMACSHA512.cls` - メインソースコード
- E-02: `Source/CorLib/System.Security.Cryptography/HMACSHA384.cls` - 類似クラス（比較用）
- E-03: `Source/CorLib/System.Security.Cryptography/HMACBase.cls` - 基盤クラス

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HMACSHA512はSHA-512を使用したHMAC実装である | E-01 (38-44行目のコメント) | ○ |
| C-02 | ハッシュサイズは512ビット（64バイト）である | E-01 (138-140行目: HashSize = 512) | ○ |
| C-03 | ProduceLegacyHmacValuesプロパティが存在する | E-01 (57-66行目) | ○ |
| C-04 | 標準モードではブロックサイズは128バイト | E-01 (276-277行目: KeySize = 128) | ○ |
| C-05 | レガシーモードではブロックサイズは64バイト | E-01 (274行目: KeySize = 64) | ○ |
| C-06 | SHA512Managedを内部で使用する | E-01 (278行目: New SHA512Managed) | ○ |
| C-07 | HashNameは"SHA512" | E-01 (278行目: "SHA512") | ○ |
| C-08 | HMACSHA384と構造的に同一である | E-01, E-02 (構造比較) | ○ |
| C-09 | ProduceLegacyHmacValues変更時にInitBaseが再実行される | E-01 (62-65行目) | ○ |
| C-10 | CanReuseTransformは常にTrueを返す | E-01 (109-111行目) | ○ |
| C-11 | CanTransformMultipleBlocksは常にTrueを返す | E-01 (118-120行目) | ○ |
| C-12 | InputBlockSizeは1を返す | E-01 (148-150行目) | ○ |
| C-13 | OutputBlockSizeは1を返す | E-01 (157-159行目) | ○ |
| C-14 | IObject, HashAlgorithm, KeyedHashAlgorithm, HMAC, ICryptoTransformを実装 | E-01 (47-51行目) | ○ |
| C-15 | Class_InitializeでInitBaseが呼ばれる | E-01 (263-265行目) | ○ |
| C-16 | Initメソッドは鍵のみを受け取る | E-01 (259-261行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 64ビット最適化の効果についての実測データ
  - 候補：プラットフォーム別ベンチマーク結果

## 5) リスクフラグ（レビュー観点）
- **リスク0（低）**: 全ての主張がソースコードから直接確認可能
- **リスク0（低）**: HMACSHA384との比較により構造が確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] HashSizeが512であることを確認
- [ ] SHA512Managedが使用されていることを確認
- [ ] HMACSHA384との差異がHashSizeとHashAlgorithmのみであることを確認
