---
generated_at: 2026-01-20 17:25:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：66-HMACRIPEMD160.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  1. **なし** - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/CorLib/System.Security.Cryptography/HMACRIPEMD160.cls` - メインソースコード
- E-02: `Source/CorLib/System.Security.Cryptography/HMACBase.cls` - 基盤クラス
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HMACRIPEMD160はRIPEMD-160を使用したHMAC実装である | E-01 (38-44行目のコメント) | ○ |
| C-02 | ハッシュサイズは160ビット（20バイト）である | E-01 (126-128行目: HashSize = 160) | ○ |
| C-03 | ブロックサイズは64バイトである | E-01 (248行目: NewHMACBase(..., 64, ...)) | ○ |
| C-04 | RIPEMD160Managedを内部で使用する | E-01 (248行目: New RIPEMD160Managed) | ○ |
| C-05 | HashNameは"RIPEMD160" | E-01 (248行目: "RIPEMD160") | ○ |
| C-06 | IObject, HashAlgorithm, KeyedHashAlgorithm, HMAC, ICryptoTransformを実装 | E-01 (47-51行目) | ○ |
| C-07 | CanReuseTransformは常にTrueを返す | E-01 (97-99行目) | ○ |
| C-08 | CanTransformMultipleBlocksは常にTrueを返す | E-01 (106-108行目) | ○ |
| C-09 | InputBlockSizeは1を返す | E-01 (136-138行目) | ○ |
| C-10 | OutputBlockSizeは1を返す | E-01 (145-147行目) | ○ |
| C-11 | Initメソッドは鍵のみを受け取る | E-01 (251-253行目) | ○ |
| C-12 | Class_InitializeでHMACBaseが初期化される | E-01 (247-249行目) | ○ |
| C-13 | ComputeHashはHMACBaseに委譲される | E-01 (166-168行目) | ○ |
| C-14 | HMACBase共通の鍵正規化ロジックを使用 | E-02 (253-281行目) | ○ |
| C-15 | 機能一覧でカテゴリはSystem.Security.Cryptography | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- HMACRIPEMD160のテストコードは確認していない
  - 候補：`Source/Tests/`配下のテストファイル

## 5) リスクフラグ（レビュー観点）
- **リスク0（低）**: 全ての技術的主張がソースコードから確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] HMACRIPEMD160.clsのClass_Initialize（248行目）でRIPEMD160Managedが使用されていることを確認
- [ ] HashSizeが160であることを確認
