---
generated_at: 2026-01-20 17:30:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：67-MACTripleDES.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. **なし** - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/CorLib/System.Security.Cryptography/MACTripleDES.cls` - メインソースコード
- E-02: `Source/CorLib/System.Security.Cryptography/CryptoStream.cls` - ストリーム暗号化
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MACTripleDESはTriple DESを使用したMAC実装である | E-01 (38-40行目のコメント) | ○ |
| C-02 | ハッシュサイズは64ビット（8バイト）である | E-01 (138-139行目: HashSize = 64) | ○ |
| C-03 | HMACBaseを使用せず独自実装 | E-01 (mBase変数なし、独自ロジック) | ○ |
| C-04 | IVは8バイトのゼロ | E-01 (315行目: Cor.NewBytes(0,0,0,0,0,0,0,0)) | ○ |
| C-05 | デフォルトPaddingはZeros | E-01 (316行目: PaddingMode.Zeros) | ○ |
| C-06 | TripleDESCryptoServiceProviderを使用 | E-01 (314行目: New TripleDESCryptoServiceProvider) | ○ |
| C-07 | mHashStream（SingleBlockStream）で最終ブロック取得 | E-01 (49行目, 130行目) | ○ |
| C-08 | StartHashでCryptoStream作成 | E-01 (351行目: Cor.NewCryptoStream) | ○ |
| C-09 | EndHashでFlushFinalBlock呼び出し | E-01 (356行目) | ○ |
| C-10 | ハッシュ開始後の鍵変更禁止 | E-01 (92-93行目) | ○ |
| C-11 | CanReuseTransformは常にTrue | E-01 (104-106行目) | ○ |
| C-12 | CanTransformMultipleBlocksは常にTrue | E-01 (114-116行目) | ○ |
| C-13 | InputBlockSizeは1 | E-01 (150-152行目) | ○ |
| C-14 | OutputBlockSizeは1 | E-01 (160-162行目) | ○ |
| C-15 | IObject, HashAlgorithm, KeyedHashAlgorithm, ICryptoTransformを実装 | E-01 (42-45行目) | ○ |
| C-16 | Clear()でリソース解放とdispose状態設定 | E-01 (169-174行目) | ○ |
| C-17 | Initialize()でStreamをNothingに設定 | E-01 (228-230行目) | ○ |
| C-18 | ComputeHashはByte配列とStreamを区別して処理 | E-01 (191-198行目) | ○ |
| C-19 | InitでCryptoConfig.CreateFromNameを使用 | E-01 (322行目) | ○ |
| C-20 | SingleBlockStreamは8バイトで初期化 | E-01 (317行目: mHashStream.Init 8) | ○ |

## 4) 不足情報（Unknown / Missing）
- SingleBlockStreamの詳細実装は確認していない
  - 候補：`Source/CorLib/System.Security.Cryptography/SingleBlockStream.cls`

## 5) リスクフラグ（レビュー観点）
- **リスク0（低）**: 全ての技術的主張がソースコードから確認可能
- **リスク1（中）**: Triple DES非推奨に関するセキュリティ警告は業界標準に基づく

## 6) レビュアーチェックリスト（最小）
- [ ] Class_Initialize（313-318行目）でIVとPaddingの初期化を確認
- [ ] StartHash（349-353行目）でCryptoStreamがWriteモードで作成されることを確認
- [ ] Hash GetでmHashStream.Hashが返されることを確認
- [ ] セキュリティ警告がプロジェクトのセキュリティポリシーと整合していることを確認
