---
generated_at: 2026-01-20 17:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：68-RNGCryptoServiceProvider.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. **なし** - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/CorLib/System.Security.Cryptography/RNGCryptoServiceProvider.cls` - メインソースコード
- E-02: `Source/CorLib/System.Security.Cryptography/RandomNumberGenerator.cls` - インターフェース
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CSPを使用した暗号論的に安全な乱数生成を提供 | E-01 (38-41行目のコメント) | ○ |
| C-02 | mProviderでCSPコンテキストハンドルを保持 | E-01 (46行目) | ○ |
| C-03 | GetBytesで配列を乱数で充填 | E-01 (54-62行目) | ○ |
| C-04 | CryptGenRandom API呼び出し | E-01 (60行目) | ○ |
| C-05 | 配列がNullの場合ArgumentNullException | E-01 (57-58行目) | ○ |
| C-06 | GetNonZeroBytesで2倍サイズの配列を用意 | E-01 (75行目: CorArray.Length(Data) * 2 - 1) | ○ |
| C-07 | ゼロ以外のバイトのみをコピー | E-01 (86-92行目) | ○ |
| C-08 | VerifyProviderで遅延初期化 | E-01 (154-158行目) | ○ |
| C-09 | デフォルトでPROV_RSA_AESを使用 | E-01 (156行目) | ○ |
| C-10 | Initで明示的にCspParametersを指定可能 | E-01 (135-142行目) | ○ |
| C-11 | Class_TerminateでReleaseContext | E-01 (144-148行目) | ○ |
| C-12 | CspParamsがNullの場合ArgumentNullException | E-01 (136-137行目) | ○ |
| C-13 | IObjectインターフェースを実装 | E-01 (43行目) | ○ |
| C-14 | RandomNumberGeneratorインターフェースを実装 | E-01 (44行目) | ○ |
| C-15 | Equalsメソッドを提供 | E-01 (103-105行目) | ○ |
| C-16 | GetHashCodeメソッドを提供 | E-01 (116-118行目) | ○ |
| C-17 | ToStringメソッドを提供 | E-01 (127-129行目) | ○ |
| C-18 | 機能一覧でカテゴリはSystem.Security.Cryptography | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- CryptoAPI.clsの詳細実装は確認していない
  - 候補：`Source/CorLib/System.Security.Cryptography/CryptoAPI.cls`

## 5) リスクフラグ（レビュー観点）
- **リスク0（低）**: 全ての技術的主張がソースコードから確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] GetBytes（54-62行目）でCryptGenRandomが呼ばれることを確認
- [ ] VerifyProvider（154-158行目）で遅延初期化が行われることを確認
- [ ] Class_Terminate（144-148行目）でコンテキストが解放されることを確認
