---
generated_at: 2026-01-20 17:40:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：69-Rfc2898DeriveBytes.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. **なし** - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/CorLib/System.Security.Cryptography/Rfc2898DeriveBytes.cls` - メインソースコード
- E-02: `Source/CorLib/System.Security.Cryptography/HMACSHA1.cls` - 内部HMAC実装
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-04: RFC 2898 - PBKDF2仕様書（外部参照）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PBKDF2アルゴリズムを実装 | E-01 (38-42行目のコメント) | ○ |
| C-02 | HMACSHA1を内部で使用 | E-01 (48行目: mHasher As HMACSHA1) | ○ |
| C-03 | ブロックサイズは20バイト | E-01 (46行目: BlockSize = 20) | ○ |
| C-04 | IterationCountプロパティで反復回数取得・設定 | E-01 (63-78行目) | ○ |
| C-05 | 反復回数が1未満ならエラー | E-01 (73-74行目) | ○ |
| C-06 | Saltプロパティでソルト取得・設定 | E-01 (88-120行目) | ○ |
| C-07 | ソルトが8バイト未満ならエラー | E-01 (115-116行目) | ○ |
| C-08 | Saltが未初期化配列ならArgumentNullException | E-01 (113行目: ValidateArray) | ○ |
| C-09 | GetBytesで任意バイト数の鍵を取得 | E-01 (128-157行目) | ○ |
| C-10 | cbが負数ならエラー | E-01 (134-135行目) | ○ |
| C-11 | 余剰バイトをバッファに保持 | E-01 (149-153行目) | ○ |
| C-12 | Resetで状態をリセット | E-01 (163-168行目) | ○ |
| C-13 | 文字列パスワードはUTF-8エンコード | E-01 (220行目: Encoding.UTF8.GetBytes) | ○ |
| C-14 | パスワードがString/Byte配列以外ならエラー | E-01 (223-224行目) | ○ |
| C-15 | ソルトサイズ指定時は自動生成 | E-01 (238行目: CryptoHelper.GetRandomBytes) | ○ |
| C-16 | ソルトサイズが負数ならエラー | E-01 (235-236行目) | ○ |
| C-17 | NextBlockBytesでPBKDF2ブロック計算 | E-01 (248-270行目) | ○ |
| C-18 | ソルト + カウンタ（BigEndian）をハッシュ | E-01 (251, 254行目) | ○ |
| C-19 | 反復回数分HMAC演算を繰り返し | E-01 (260-267行目) | ○ |
| C-20 | 各反復結果をXORで累積 | E-01 (264-266行目) | ○ |
| C-21 | IObjectインターフェースを実装 | E-01 (44行目) | ○ |
| C-22 | 機能一覧でカテゴリはSystem.Security.Cryptography | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- SwapEndian関数の詳細実装は確認していない
  - 候補：共通ユーティリティ関数

## 5) リスクフラグ（レビュー観点）
- **リスク0（低）**: 全ての技術的主張がソースコードから確認可能
- **リスク1（中）**: 推奨反復回数（10,000以上）は業界標準に基づくが、用途によって調整が必要

## 6) レビュアーチェックリスト（最小）
- [ ] GetBytes（128-157行目）でブロック計算と余剰バッファリングが正しいことを確認
- [ ] NextBlockBytes（248-270行目）でPBKDF2アルゴリズムが正しく実装されていることを確認
- [ ] ソルトの最小長チェック（8バイト）がRFC準拠であることを確認
