---
generated_at: 2026-01-20 11:40:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：7-Version.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/CorLib/System/Version.cls` 38-43行目（モジュールコメント）
- E-02: `Source/CorLib/System/Version.cls` 45-47行目（インターフェース実装）
- E-03: `Source/CorLib/System/Version.cls` 54-58行目（定数定義）
- E-04: `Source/CorLib/System/Version.cls` 60-63行目（内部変数）
- E-05: `Source/CorLib/System/Version.cls` 70-72行目（Majorプロパティ）
- E-06: `Source/CorLib/System/Version.cls` 78-80行目（Minorプロパティ）
- E-07: `Source/CorLib/System/Version.cls` 87-89行目（Buildプロパティ）
- E-08: `Source/CorLib/System/Version.cls` 96-98行目（Revisionプロパティ）
- E-09: `Source/CorLib/System/Version.cls` 104-106行目（MinorRevisionプロパティ）
- E-10: `Source/CorLib/System/Version.cls` 112-114行目（MajorRevisionプロパティ）
- E-11: `Source/CorLib/System/Version.cls` 120-123行目（Cloneメソッド）
- E-12: `Source/CorLib/System/Version.cls` 157-167行目（CompareToメソッド）
- E-13: `Source/CorLib/System/Version.cls` 211-236行目（ToStringメソッド）
- E-14: `Source/CorLib/System/Version.cls` 243-253行目（Equalsメソッド）
- E-15: `Source/CorLib/System/Version.cls` 259-265行目（GetHashCodeメソッド）
- E-16: `Source/CorLib/System/Version.cls` 272-274行目（EqualToメソッド）
- E-17: `Source/CorLib/System/Version.cls` 281-283行目（LessThanメソッド）
- E-18: `Source/CorLib/System/Version.cls` 290-292行目（LessThanOrEqualToメソッド）
- E-19: `Source/CorLib/System/Version.cls` 299-301行目（GreaterThanメソッド）
- E-20: `Source/CorLib/System/Version.cls` 308-310行目（GreaterThanOrEqualToメソッド）
- E-21: `Source/CorLib/System/Version.cls` 317-319行目（NotEqualToメソッド）
- E-22: `Source/CorLib/System/Version.cls` 330-357行目（Initメソッド）
- E-23: `Source/CorLib/System/Version.cls` 370-378行目（GetMaxFieldCountメソッド）
- E-24: `Source/CorLib/System/Version.cls` 380-389行目（EqualFieldsメソッド）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Major.Minor[.Build[.Revision]]形式 | E-01 | ○ |
| C-02 | IObject、ICloneable、IComparableを実装 | E-02 | ○ |
| C-03 | 未定義コンポーネントは-1 | E-03 | ○ |
| C-04 | mMajor/mMinor/mBuild/mRevisionで管理 | E-04 | ○ |
| C-05 | Majorプロパティ | E-05 | ○ |
| C-06 | Minorプロパティ | E-06 | ○ |
| C-07 | Buildプロパティ（未定義時-1） | E-07 | ○ |
| C-08 | Revisionプロパティ（未定義時-1） | E-08 | ○ |
| C-09 | MinorRevisionは下位16ビット | E-09 | ○ |
| C-10 | MajorRevisionは上位16ビット | E-10 | ○ |
| C-11 | CloneはInitCloneを使用 | E-11 | ○ |
| C-12 | CompareToはMajor→Minor→Build→Revisionの順 | E-12 | ○ |
| C-13 | ToStringはFieldCountで出力要素を制御 | E-13 | ○ |
| C-14 | EqualsはVersion型のみ対応 | E-14 | ○ |
| C-15 | GetHashCodeはシフトとORで算出 | E-15 | ○ |
| C-16 | EqualToはCompareToを使用 | E-16 | ○ |
| C-17 | LessThan/GreaterThan等の比較メソッド | E-17, E-18, E-19, E-20, E-21 | ○ |
| C-18 | Initでバリデーション実行 | E-22 | ○ |
| C-19 | Revision指定時はBuild必須 | E-22 | ○ |
| C-20 | 負の値でエラー | E-22 | ○ |
| C-21 | GetMaxFieldCountで最大要素数を判定 | E-23 | ○ |
| C-22 | EqualFieldsで比較結果を返す | E-24 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Versionクラスの実装は完全に確認済み
- 0: 低リスク - 比較ロジックは単純で明確

## 6) レビュアーチェックリスト（最小）
- [ ] VersionStaticの実装確認（Parse、TryParse等）
- [ ] 境界値テスト（0、-1、最大値）
- [ ] ToString(FieldCount)の動作確認
