---
generated_at: 2026-01-20 10:10:00
metrics:
  claims_total: 28
  claims_with_evidence: 28
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：73-CultureInfo

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：28 / 28、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/CorLib/System.Globalization/CultureInfo.cls` 行1-603
- E-02: `Source/CorLib/System.Globalization/CultureInfo.cls` 行38-45（クラスコメント）
- E-03: `Source/CorLib/System.Globalization/CultureInfo.cls` 行47-49（インターフェース実装）
- E-04: `Source/CorLib/System.Globalization/CultureInfo.cls` 行81-93（PropsType構造体）
- E-05: `Source/CorLib/System.Globalization/CultureInfo.cls` 行66-78（カレンダー定数）
- E-06: `Source/CorLib/System.Globalization/CultureInfo.cls` 行421-448（Init関数）
- E-07: `Source/CorLib/System.Globalization/CultureInfo.cls` 行472-490（Load関数）
- E-08: `Source/CorLib/System.Globalization/CultureInfo.cls` 行492-504（LoadDefault関数）
- E-09: `Source/CorLib/System.Globalization/CultureInfo.cls` 行317-326（NumberFormatプロパティGet）
- E-10: `Source/CorLib/System.Globalization/CultureInfo.cls` 行349-358（DateTimeFormatプロパティGet）
- E-11: `Source/CorLib/System.Globalization/CultureInfo.cls` 行108-114（CalendarプロパティGet）
- E-12: `Source/CorLib/System.Globalization/CultureInfo.cls` 行506-528（GetCalendar関数）
- E-13: `Source/CorLib/System.Globalization/CultureInfo.cls` 行303-309（GetFormat関数）
- E-14: `Source/CorLib/System.Globalization/CultureInfo.cls` 行193-198（IsNeutralCultureプロパティ）
- E-15: `Source/CorLib/System.Globalization/CultureInfo.cls` 行209-219（MarkReadOnly関数）
- E-16: `Source/CorLib/System.Globalization/CultureInfo.cls` 行462-464（VerifyWritable関数）
- E-17: `Source/CorLib/System.Globalization/CultureInfo.cls` 行276-295（Clone関数）
- E-18: `Source/CorLib/System.Globalization/CultureInfo.cls` 行381-383（Parentプロパティ）
- E-19: `Source/CorLib/System.Globalization/CultureInfo.cls` 行534-570（シリアライズ処理）
- E-20: `Source/CorLib/System.Globalization/CultureInfoStatic.cls` 行1-158
- E-21: `Source/CorLib/System.Globalization/CultureInfoStatic.cls` 行56-61（CultureTypes列挙型）
- E-22: `Source/CorLib/System.Globalization/CultureInfoStatic.cls` 行97-99（CurrentCultureプロパティ）
- E-23: `Source/CorLib/System.Globalization/CultureInfoStatic.cls` 行118-125（InvariantCultureプロパティ）
- E-24: `Source/CorLib/System.Globalization/CultureInfo.cls` 行14-32（MITライセンス）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IObjectインターフェースを実装 | E-03 | ○ |
| C-02 | ICloneableインターフェースを実装 | E-03 | ○ |
| C-03 | IFormatProviderインターフェースを実装 | E-03 | ○ |
| C-04 | PropsType構造体でプロパティを管理 | E-04 | ○ |
| C-05 | 13種類のカレンダータイプをサポート | E-05 | ○ |
| C-06 | Init関数でNameOrLCIDから初期化 | E-06 | ○ |
| C-07 | 文字列型はCultureTableでLCID検索 | E-06（行428-431） | ○ |
| C-08 | 空文字列はINVARIANT_LCIDを使用 | E-06（行432-434） | ○ |
| C-09 | LCIDが負数の場合ArgumentOutOfRange | E-06（行445-446） | ○ |
| C-10 | CultureTableからプロパティをロード | E-07 | ○ |
| C-11 | CultureTable未ロード時はデフォルト値使用 | E-08 | ○ |
| C-12 | NumberFormatは遅延ロード | E-09 | ○ |
| C-13 | ニュートラルカルチャはフォーマット不可 | E-09（行318-319）, E-10（行350-351） | ○ |
| C-14 | DateTimeFormatは遅延ロード | E-10 | ○ |
| C-15 | Calendarは遅延ロード | E-11 | ○ |
| C-16 | GetCalendarでカレンダータイプに応じた生成 | E-12 | ○ |
| C-17 | GetFormatでNumberFormatInfo取得可能 | E-13（行304-305） | ○ |
| C-18 | GetFormatでDateTimeFormatInfo取得可能 | E-13（行306-308） | ○ |
| C-19 | IsNeutralCultureプロパティで中立カルチャ判定 | E-14 | ○ |
| C-20 | MarkReadOnlyでReadOnlyフラグ設定 | E-15 | ○ |
| C-21 | ReadOnlyカルチャは変更不可 | E-16 | ○ |
| C-22 | Cloneで複製可能 | E-17 | ○ |
| C-23 | Parentで親カルチャ取得 | E-18 | ○ |
| C-24 | PropertyBagでシリアライズ対応 | E-19 | ○ |
| C-25 | CultureInfoStaticで静的メソッド提供 | E-20 | ○ |
| C-26 | CultureTypes列挙型でフィルタ指定 | E-21 | ○ |
| C-27 | CurrentCultureでスレッドカルチャ取得 | E-22 | ○ |
| C-28 | InvariantCultureはシングルトン | E-23 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] CultureTableクラスが正しくカルチャデータをロードしているか確認
- [ ] カレンダータイプマッピング（GetCalendar）が.NET Frameworkと一致しているか確認
- [ ] LCID構造（32ビット形式）がWindowsの仕様と一致しているか確認
- [ ] InvariantCultureのデフォルト値（"Invariant Language"等）が適切か確認
