---
generated_at: 2026-01-20 10:20:00
metrics:
  claims_total: 32
  claims_with_evidence: 32
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：74-DateTimeFormatInfo

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：32 / 32、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/CorLib/System.Globalization/DateTimeFormatInfo.cls` 行1-1362
- E-02: `Source/CorLib/System.Globalization/DateTimeFormatInfo.cls` 行38-51（クラスコメント）
- E-03: `Source/CorLib/System.Globalization/DateTimeFormatInfo.cls` 行53-55（インターフェース実装）
- E-04: `Source/CorLib/System.Globalization/DateTimeFormatInfo.cls` 行84-109（PropsType構造体）
- E-05: `Source/CorLib/System.Globalization/DateTimeFormatInfo.cls` 行77-79（固定パターン定数）
- E-06: `Source/CorLib/System.Globalization/DateTimeFormatInfo.cls` 行784-797（Init関数）
- E-07: `Source/CorLib/System.Globalization/DateTimeFormatInfo.cls` 行838-852（LoadCommon関数）
- E-08: `Source/CorLib/System.Globalization/DateTimeFormatInfo.cls` 行810-822（LoadUserOverride関数）
- E-09: `Source/CorLib/System.Globalization/DateTimeFormatInfo.cls` 行824-836（LoadFromCultureTable関数）
- E-10: `Source/CorLib/System.Globalization/DateTimeFormatInfo.cls` 行745-748（Format関数）
- E-11: `Source/CorLib/System.Globalization/DateTimeFormatInfo.cls` 行1086-1126（GetPattern関数）
- E-12: `Source/CorLib/System.Globalization/DateTimeFormatInfo.cls` 行855-1018（CustomFormat関数）
- E-13: `Source/CorLib/System.Globalization/DateTimeFormatInfo.cls` 行167-181（AbbreviatedDayNamesプロパティ）
- E-14: `Source/CorLib/System.Globalization/DateTimeFormatInfo.cls` 行188-203（AbbreviatedMonthNamesプロパティ）
- E-15: `Source/CorLib/System.Globalization/DateTimeFormatInfo.cls` 行256-270（DayNamesプロパティ）
- E-16: `Source/CorLib/System.Globalization/DateTimeFormatInfo.cls` 行414-429（MonthNamesプロパティ）
- E-17: `Source/CorLib/System.Globalization/DateTimeFormatInfo.cls` 行210-225（AMDesignatorプロパティ）
- E-18: `Source/CorLib/System.Globalization/DateTimeFormatInfo.cls` 行436-451（PMDesignatorプロパティ）
- E-19: `Source/CorLib/System.Globalization/DateTimeFormatInfo.cls` 行233-249（DateSeparatorプロパティ）
- E-20: `Source/CorLib/System.Globalization/DateTimeFormatInfo.cls` 行524-539（TimeSeparatorプロパティ）
- E-21: `Source/CorLib/System.Globalization/DateTimeFormatInfo.cls` 行278-293（FirstDayOfWeekプロパティ）
- E-22: `Source/CorLib/System.Globalization/DateTimeFormatInfo.cls` 行120-134（CalendarWeekRuleプロパティ）
- E-23: `Source/CorLib/System.Globalization/DateTimeFormatInfo.cls` 行459-461（RFC1123Patternプロパティ）
- E-24: `Source/CorLib/System.Globalization/DateTimeFormatInfo.cls` 行515-517（SortableDateTimePatternプロパティ）
- E-25: `Source/CorLib/System.Globalization/DateTimeFormatInfo.cls` 行550-552（UniversalSortableDateTimePatternプロパティ）
- E-26: `Source/CorLib/System.Globalization/DateTimeFormatInfo.cls` 行301-307（FullDateTimePatternプロパティ）
- E-27: `Source/CorLib/System.Globalization/DateTimeFormatInfo.cls` 行331-334（MarkReadOnly関数）
- E-28: `Source/CorLib/System.Globalization/DateTimeFormatInfo.cls` 行1223-1227（VerifyWritable関数）
- E-29: `Source/CorLib/System.Globalization/DateTimeFormatInfo.cls` 行597-603（GetAbbreviatedDayName関数）
- E-30: `Source/CorLib/System.Globalization/DateTimeFormatInfo.cls` 行626-633（GetAbbreviatedMonthName関数）
- E-31: `Source/CorLib/System.Globalization/DateTimeFormatInfo.cls` 行1263-1275（CopyArray関数 - 配列検証）
- E-32: `Source/CorLib/System.Globalization/DateTimeFormatInfo.cls` 行14-32（MITライセンス）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IObjectインターフェースを実装 | E-03 | ○ |
| C-02 | ICloneableインターフェースを実装 | E-03 | ○ |
| C-03 | IFormatProviderインターフェースを実装 | E-03 | ○ |
| C-04 | PropsType構造体で書式情報を管理 | E-04 | ○ |
| C-05 | RFC1123Patternは固定値 | E-05, E-23 | ○ |
| C-06 | SortableDateTimePatternは固定値 | E-05, E-24 | ○ |
| C-07 | UniversalSortableDateTimePatternは固定値 | E-05, E-25 | ○ |
| C-08 | Init関数でLCIDとUseUserOverrideを受け取る | E-06 | ○ |
| C-09 | CultureTable未ロード時はNotSupportedException | E-06（行785-786） | ○ |
| C-10 | LoadCommonで共通情報をロード | E-07 | ○ |
| C-11 | UseUserOverride時はWindows APIを使用 | E-08 | ○ |
| C-12 | UseUserOverride=False時はCultureTableを使用 | E-09 | ○ |
| C-13 | Format関数でVerifyLoadedを呼び出す | E-10 | ○ |
| C-14 | GetPatternで書式指定子をパターンに変換 | E-11 | ○ |
| C-15 | CustomFormatでパターンを適用 | E-12 | ○ |
| C-16 | AbbreviatedDayNamesは7要素固定 | E-13（行180） | ○ |
| C-17 | AbbreviatedMonthNamesは13要素固定 | E-14（行202） | ○ |
| C-18 | DayNamesは7要素固定 | E-15（行269） | ○ |
| C-19 | MonthNamesは13要素固定 | E-16（行428） | ○ |
| C-20 | AMDesignatorプロパティを提供 | E-17 | ○ |
| C-21 | PMDesignatorプロパティを提供 | E-18 | ○ |
| C-22 | DateSeparatorプロパティを提供 | E-19 | ○ |
| C-23 | TimeSeparatorプロパティを提供 | E-20 | ○ |
| C-24 | FirstDayOfWeekプロパティを提供 | E-21 | ○ |
| C-25 | CalendarWeekRuleプロパティを提供 | E-22 | ○ |
| C-26 | FullDateTimePatternは自動生成可能 | E-26（行303-305） | ○ |
| C-27 | MarkReadOnlyでReadOnlyフラグ設定 | E-27 | ○ |
| C-28 | ReadOnlyインスタンスは変更不可 | E-28 | ○ |
| C-29 | GetAbbreviatedDayNameで曜日範囲チェック | E-29（行598-599） | ○ |
| C-30 | GetAbbreviatedMonthNameで月範囲チェック（1-13） | E-30（行629-630） | ○ |
| C-31 | CopyArrayで配列サイズ検証 | E-31 | ○ |
| C-32 | MITライセンスで提供 | E-32 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 書式指定子（d, D, t, T, f, F, g, G, m, r, s, u, y）が.NET Frameworkと同一動作か確認
- [ ] CustomFormat関数のパターン解釈がRFC 3339およびISO 8601に準拠しているか確認
- [ ] 13ヶ月カレンダー対応の月名配列（13要素）が正しく機能しているか確認
- [ ] DayOfWeekが0-6の範囲（VB標準の1-7とは異なる）であることをドキュメント化
