---
generated_at: 2026-01-20 10:30:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：75-NumberFormatInfo

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/CorLib/System.Globalization/NumberFormatInfo.cls` 行1-400+
- E-02: `Source/CorLib/System.Globalization/NumberFormatInfo.cls` 行38-52（クラスコメント）
- E-03: `Source/CorLib/System.Globalization/NumberFormatInfo.cls` 行54-56（インターフェース実装）
- E-04: `Source/CorLib/System.Globalization/NumberFormatInfo.cls` 行94-100（NumberNegativePatterns列挙型）
- E-05: `Source/CorLib/System.Globalization/NumberFormatInfo.cls` 行122-139（CurrencyNegativePatterns列挙型）
- E-06: `Source/CorLib/System.Globalization/NumberFormatInfo.cls` 行148-153（CurrencyPositivePatterns列挙型）
- E-07: `Source/CorLib/System.Globalization/NumberFormatInfo.cls` 行162-167（PercentPositivePatterns列挙型）
- E-08: `Source/CorLib/System.Globalization/NumberFormatInfo.cls` 行185-198（PercentNegativePatterns列挙型）
- E-09: `Source/CorLib/System.Globalization/NumberFormatInfo.cls` 行200-228（PropsType構造体）
- E-10: `Source/CorLib/System.Globalization/NumberFormatInfo.cls` 行239-245（IsReadOnly、MarkReadOnly）
- E-11: `Source/CorLib/System.Globalization/NumberFormatInfo.cls` 行252-255（Clone関数）
- E-12: `Source/CorLib/System.Globalization/NumberFormatInfo.cls` 行263-278（NegativeInfinitySymbolプロパティ）
- E-13: `Source/CorLib/System.Globalization/NumberFormatInfo.cls` 行286-301（PositiveInfinitySymbolプロパティ）
- E-14: `Source/CorLib/System.Globalization/NumberFormatInfo.cls` 行313-332（PerMilleSymbolプロパティ）
- E-15: `Source/CorLib/System.Globalization/NumberFormatInfo.cls` 行340-355（NaNSymbolプロパティ）
- E-16: `Source/CorLib/System.Globalization/NumberFormatInfo.cls` 行14-32（MITライセンス）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IObjectインターフェースを実装 | E-03 | ○ |
| C-02 | IFormatProviderインターフェースを実装 | E-03 | ○ |
| C-03 | ICloneableインターフェースを実装 | E-03 | ○ |
| C-04 | PropsType構造体で書式情報を管理 | E-09 | ○ |
| C-05 | NumberNegativePatterns列挙型で5種類の負数パターン | E-04 | ○ |
| C-06 | CurrencyNegativePatterns列挙型で16種類の負の通貨パターン | E-05 | ○ |
| C-07 | CurrencyPositivePatterns列挙型で4種類の正の通貨パターン | E-06 | ○ |
| C-08 | PercentPositivePatterns列挙型で4種類の正のパーセントパターン | E-07 | ○ |
| C-09 | PercentNegativePatterns列挙型で12種類の負のパーセントパターン | E-08 | ○ |
| C-10 | IsReadOnlyプロパティを提供 | E-10 | ○ |
| C-11 | MarkReadOnlyでReadOnlyフラグ設定 | E-10 | ○ |
| C-12 | Clone関数で複製可能 | E-11 | ○ |
| C-13 | NegativeInfinitySymbolプロパティを提供 | E-12 | ○ |
| C-14 | PositiveInfinitySymbolプロパティを提供 | E-13 | ○ |
| C-15 | PerMilleSymbolプロパティを提供 | E-14 | ○ |
| C-16 | NaNSymbolプロパティを提供 | E-15 | ○ |
| C-17 | PercentDecimalSeparatorプロパティを提供 | E-01（行361-373） | ○ |
| C-18 | PercentDecimalDigitsプロパティを提供 | E-01（行389-392） | ○ |
| C-19 | VerifyWritableで変更可否チェック | E-12（行275）等 | ○ |
| C-20 | MITライセンスで提供 | E-16 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] パターン列挙型の値が.NET Frameworkと一致しているか確認
- [ ] CultureTableからのロード処理が正しく動作しているか確認
- [ ] 特殊値（NaN、Infinity）の表現がIEEE 754準拠か確認
