---
generated_at: 2026-01-20 10:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：76-GregorianCalendar

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/CorLib/System.Globalization/GregorianCalendar.cls` 行1-300
- E-02: `Source/CorLib/System.Globalization/GregorianCalendar.cls` 行38-51（クラスコメント）
- E-03: `Source/CorLib/System.Globalization/GregorianCalendar.cls` 行53-55（インターフェース実装）
- E-04: `Source/CorLib/System.Globalization/GregorianCalendar.cls` 行70-77（GregorianCalendarTypes列挙型）
- E-05: `Source/CorLib/System.Globalization/GregorianCalendar.cls` 行89-91（AlgorithmTypeプロパティ）
- E-06: `Source/CorLib/System.Globalization/GregorianCalendar.cls` 行98-100（IsReadOnlyプロパティ）
- E-07: `Source/CorLib/System.Globalization/GregorianCalendar.cls` 行108-111（Clone関数）
- E-08: `Source/CorLib/System.Globalization/GregorianCalendar.cls` 行120-122（CalendarTypeプロパティGet）
- E-09: `Source/CorLib/System.Globalization/GregorianCalendar.cls` 行144-154（CalendarTypeプロパティLet）
- E-10: `Source/CorLib/System.Globalization/GregorianCalendar.cls` 行163-165（Erasプロパティ）
- E-11: `Source/CorLib/System.Globalization/GregorianCalendar.cls` 行177-179（TwoDigitYearMaxプロパティGet）
- E-12: `Source/CorLib/System.Globalization/GregorianCalendar.cls` 行191-200（TwoDigitYearMaxプロパティLet）
- E-13: `Source/CorLib/System.Globalization/GregorianCalendar.cls` 行207-209（MinSupportedDateTimeプロパティ）
- E-14: `Source/CorLib/System.Globalization/GregorianCalendar.cls` 行216-218（MaxSupportedDateTimeプロパティ）
- E-15: `Source/CorLib/System.Globalization/GregorianCalendar.cls` 行232-234（AddDays関数）
- E-16: `Source/CorLib/System.Globalization/GregorianCalendar.cls` 行14-32（MITライセンス）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IObjectインターフェースを実装 | E-03 | ○ |
| C-02 | Calendarインターフェースを実装 | E-03 | ○ |
| C-03 | ICloneableインターフェースを実装 | E-03 | ○ |
| C-04 | GregorianCalendarTypes列挙型で6種類の言語バージョン | E-04 | ○ |
| C-05 | AlgorithmTypeはSolarCalendarを返す | E-05 | ○ |
| C-06 | IsReadOnlyプロパティを提供 | E-06 | ○ |
| C-07 | Clone関数で複製可能 | E-07 | ○ |
| C-08 | CalendarTypeプロパティを提供 | E-08, E-09 | ○ |
| C-09 | CalendarType設定時にVerifyWritableチェック | E-09（行145） | ○ |
| C-10 | CalendarType設定時に範囲チェック | E-09（行147-153） | ○ |
| C-11 | Erasプロパティは{1}を返す | E-10 | ○ |
| C-12 | TwoDigitYearMaxプロパティを提供 | E-11, E-12 | ○ |
| C-13 | TwoDigitYearMax設定時に99-9999の範囲チェック | E-12（行196-197） | ○ |
| C-14 | MinSupportedDateTimeはCorDateTime.MinValue | E-13 | ○ |
| C-15 | MaxSupportedDateTimeはCorDateTime.MaxValue | E-14 | ○ |
| C-16 | AddDaysはStatics.Calendar経由で実装 | E-15 | ○ |
| C-17 | ADエラ（1）のみサポート | E-02（行42-43）, E-10 | ○ |
| C-18 | MITライセンスで提供 | E-16 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 閏年判定ロジックがグレゴリオ暦の規則に準拠しているか確認
- [ ] GregorianCalendarTypes列挙型が.NET Frameworkと一致しているか確認
- [ ] Statics.Calendarクラスとの連携が正しく動作しているか確認
