---
generated_at: 2026-01-20 10:40:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：77-JulianCalendar

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/CorLib/System.Globalization/JulianCalendar.cls` 行1-200
- E-02: `Source/CorLib/System.Globalization/JulianCalendar.cls` 行38-43（クラスコメント）
- E-03: `Source/CorLib/System.Globalization/JulianCalendar.cls` 行45-47（インターフェース実装）
- E-04: `Source/CorLib/System.Globalization/JulianCalendar.cls` 行49-51（定数定義）
- E-05: `Source/CorLib/System.Globalization/JulianCalendar.cls` 行72-74（AlgorithmTypeプロパティ）
- E-06: `Source/CorLib/System.Globalization/JulianCalendar.cls` 行82-84（Erasプロパティ）
- E-07: `Source/CorLib/System.Globalization/JulianCalendar.cls` 行91-102（Min/MaxSupportedDateTimeプロパティ）
- E-08: `Source/CorLib/System.Globalization/JulianCalendar.cls` 行109-112（Clone関数）
- E-09: `Source/CorLib/System.Globalization/JulianCalendar.cls` 行119-121（IsReadOnlyプロパティ）
- E-10: `Source/CorLib/System.Globalization/JulianCalendar.cls` 行128-160（TwoDigitYearMaxプロパティ）
- E-11: `Source/CorLib/System.Globalization/JulianCalendar.cls` 行169-171（AddDays関数）
- E-12: `Source/CorLib/System.Globalization/JulianCalendar.cls` 行14-32（MITライセンス）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IObjectインターフェースを実装 | E-03 | ○ |
| C-02 | Calendarインターフェースを実装 | E-03 | ○ |
| C-03 | ICloneableインターフェースを実装 | E-03 | ○ |
| C-04 | DefaultTwoDigitYearMaxは2029 | E-04 | ○ |
| C-05 | AlgorithmTypeはSolarCalendarを返す | E-05 | ○ |
| C-06 | ErasはJulianEra（1）を含む配列を返す | E-06 | ○ |
| C-07 | MinSupportedDateTimeはCorDateTime.MinValue | E-07 | ○ |
| C-08 | MaxSupportedDateTimeはCorDateTime.MaxValue | E-07 | ○ |
| C-09 | Clone関数で複製可能 | E-08 | ○ |
| C-10 | IsReadOnlyプロパティを提供 | E-09 | ○ |
| C-11 | TwoDigitYearMax設定時に99-9999の範囲チェック | E-10（行156-157） | ○ |
| C-12 | TwoDigitYearMax設定時にVerifyWritableチェック | E-10（行154） | ○ |
| C-13 | AddDaysはStatics.Calendar経由で実装 | E-11 | ○ |
| C-14 | MITライセンスで提供 | E-12 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] ユリウス暦の閏年判定が正しく4年ごと（例外なし）であることを確認
- [ ] グレゴリオ暦との日付変換が正しいことを確認
