---
generated_at: 2026-01-20 10:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：78-JapaneseCalendar

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/CorLib/System.Globalization/JapaneseCalendar.cls` 行1-200
- E-02: `Source/CorLib/System.Globalization/JapaneseCalendar.cls` 行38-43（クラスコメント）
- E-03: `Source/CorLib/System.Globalization/JapaneseCalendar.cls` 行45-47（インターフェース実装）
- E-04: `Source/CorLib/System.Globalization/JapaneseCalendar.cls` 行49-54（定数定義）
- E-05: `Source/CorLib/System.Globalization/JapaneseCalendar.cls` 行55-61（EraInfo構造体）
- E-06: `Source/CorLib/System.Globalization/JapaneseCalendar.cls` 行75-78（Clone関数）
- E-07: `Source/CorLib/System.Globalization/JapaneseCalendar.cls` 行85-87（AlgorithmTypeプロパティ）
- E-08: `Source/CorLib/System.Globalization/JapaneseCalendar.cls` 行94-96（IsReadOnlyプロパティ）
- E-09: `Source/CorLib/System.Globalization/JapaneseCalendar.cls` 行99-139（Erasプロパティ - コメント）
- E-10: `Source/CorLib/System.Globalization/JapaneseCalendar.cls` 行137-139（Erasプロパティ - 実装）
- E-11: `Source/CorLib/System.Globalization/JapaneseCalendar.cls` 行146-148（TwoDigitYearMaxプロパティGet）
- E-12: `Source/CorLib/System.Globalization/JapaneseCalendar.cls` 行155-162（TwoDigitYearMaxプロパティLet）
- E-13: `Source/CorLib/System.Globalization/JapaneseCalendar.cls` 行169-171（MaxSupportedDateTimeプロパティ）
- E-14: `Source/CorLib/System.Globalization/JapaneseCalendar.cls` 行178-180（MinSupportedDateTimeプロパティ）
- E-15: `Source/CorLib/System.Globalization/JapaneseCalendar.cls` 行189-191（AddDays関数）
- E-16: `Source/CorLib/System.Globalization/JapaneseCalendar.cls` 行14-32（MITライセンス）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IObjectインターフェースを実装 | E-03 | ○ |
| C-02 | Calendarインターフェースを実装 | E-03 | ○ |
| C-03 | ICloneableインターフェースを実装 | E-03 | ○ |
| C-04 | MinEra=1, MaxEra=4の定数定義 | E-04 | ○ |
| C-05 | EraInfo構造体で元号情報を管理 | E-05 | ○ |
| C-06 | Clone関数で複製可能 | E-06 | ○ |
| C-07 | AlgorithmTypeはSolarCalendarを返す | E-07 | ○ |
| C-08 | IsReadOnlyプロパティを提供 | E-08 | ○ |
| C-09 | 4つの元号をサポート（平成, 昭和, 大正, 明治） | E-09, E-10 | ○ |
| C-10 | Erasは{4, 3, 2, 1}を返す | E-10 | ○ |
| C-11 | DefaultTwoDigitYearMaxは99 | E-04（行50） | ○ |
| C-12 | TwoDigitYearMax設定時に範囲チェック | E-12（行158-159） | ○ |
| C-13 | MaxSupportedDateTimeはCorDateTime.MaxValue | E-13 | ○ |
| C-14 | MinSupportedDateTimeは1868/9/8 | E-14 | ○ |
| C-15 | AddDaysはStatics.Calendar経由で実装 | E-15 | ○ |
| C-16 | MITライセンスで提供 | E-16 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 元号切替日が正確に設定されているか確認
- [ ] 令和（2019年5月1日〜）のサポート状況を確認
- [ ] 元年（Gannen）の表記に関する処理を確認
