---
generated_at: 2026-01-20 10:50:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：79-HebrewCalendar

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/CorLib/System.Globalization/HebrewCalendar.cls` 行1-200
- E-02: `Source/CorLib/System.Globalization/HebrewCalendar.cls` 行38-43（クラスコメント）
- E-03: `Source/CorLib/System.Globalization/HebrewCalendar.cls` 行45-47（インターフェース実装）
- E-04: `Source/CorLib/System.Globalization/HebrewCalendar.cls` 行51-54（EPOCH定数・コメント）
- E-05: `Source/CorLib/System.Globalization/HebrewCalendar.cls` 行64-65（年範囲定数）
- E-06: `Source/CorLib/System.Globalization/HebrewCalendar.cls` 行77-79（AlgorithmTypeプロパティ）
- E-07: `Source/CorLib/System.Globalization/HebrewCalendar.cls` 行87-89（Erasプロパティ）
- E-08: `Source/CorLib/System.Globalization/HebrewCalendar.cls` 行98-100（TwoDigitYearMaxプロパティGet）
- E-09: `Source/CorLib/System.Globalization/HebrewCalendar.cls` 行124-132（TwoDigitYearMaxプロパティLet）
- E-10: `Source/CorLib/System.Globalization/HebrewCalendar.cls` 行139-141（IsReadOnlyプロパティ）
- E-11: `Source/CorLib/System.Globalization/HebrewCalendar.cls` 行149-152（Clone関数）
- E-12: `Source/CorLib/System.Globalization/HebrewCalendar.cls` 行159-161（MinSupportedDateTimeプロパティ）
- E-13: `Source/CorLib/System.Globalization/HebrewCalendar.cls` 行168-170（MaxSupportedDateTimeプロパティ）
- E-14: `Source/CorLib/System.Globalization/HebrewCalendar.cls` 行179-181（AddDays関数）
- E-15: `Source/CorLib/System.Globalization/HebrewCalendar.cls` 行14-32（MITライセンス）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IObjectインターフェースを実装 | E-03 | ○ |
| C-02 | Calendarインターフェースを実装 | E-03 | ○ |
| C-03 | ICloneableインターフェースを実装 | E-03 | ○ |
| C-04 | エポックはRD -1,373,427 | E-04 | ○ |
| C-05 | MinHebrewYear=5343, MaxHebrewYear=5999 | E-05 | ○ |
| C-06 | AlgorithmTypeはLunisolarCalendarを返す | E-06 | ○ |
| C-07 | ErasはHebrewEra（1）を含む配列を返す | E-07 | ○ |
| C-08 | TwoDigitYearMaxプロパティを提供 | E-08, E-09 | ○ |
| C-09 | TwoDigitYearMax設定時にValidateHebrewYear呼び出し | E-09（行127-128） | ○ |
| C-10 | 99は特別値として許可 | E-09（行127） | ○ |
| C-11 | IsReadOnlyプロパティを提供 | E-10 | ○ |
| C-12 | Clone関数で複製可能 | E-11 | ○ |
| C-13 | MinSupportedDateTimeは静的プロパティ参照 | E-12 | ○ |
| C-14 | MaxSupportedDateTimeは静的プロパティ参照 | E-13 | ○ |
| C-15 | AddDaysはStatics.Calendar経由で実装 | E-14 | ○ |
| C-16 | MITライセンスで提供 | E-15 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 19年周期の閏年判定が正しく実装されているか確認
- [ ] 年の種類（不足年/通常年/過剰年）の判定ロジックを確認
- [ ] ヘブライ暦の月名と日数が正しいか確認
