---
generated_at: 2026-01-20 10:55:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：80-HijriCalendar

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/CorLib/System.Globalization/HijriCalendar.cls` 行1-200
- E-02: `Source/CorLib/System.Globalization/HijriCalendar.cls` 行38-45（クラスコメント）
- E-03: `Source/CorLib/System.Globalization/HijriCalendar.cls` 行47-49（インターフェース実装）
- E-04: `Source/CorLib/System.Globalization/HijriCalendar.cls` 行51-53（デフォルトTwoDigitYearMax）
- E-05: `Source/CorLib/System.Globalization/HijriCalendar.cls` 行56-60（EPOCH定数・コメント）
- E-06: `Source/CorLib/System.Globalization/HijriCalendar.cls` 行62-70（30年周期定数）
- E-07: `Source/CorLib/System.Globalization/HijriCalendar.cls` 行73-75（MaxYear定数）
- E-08: `Source/CorLib/System.Globalization/HijriCalendar.cls` 行98-100（AlgorithmTypeプロパティ）
- E-09: `Source/CorLib/System.Globalization/HijriCalendar.cls` 行107-110（Clone関数）
- E-10: `Source/CorLib/System.Globalization/HijriCalendar.cls` 行117-119（IsReadOnlyプロパティ）
- E-11: `Source/CorLib/System.Globalization/HijriCalendar.cls` 行127-129（MaxSupportedDateTimeプロパティ）
- E-12: `Source/CorLib/System.Globalization/HijriCalendar.cls` 行136-138（MinSupportedDateTimeプロパティ）
- E-13: `Source/CorLib/System.Globalization/HijriCalendar.cls` 行143-145（HijriAdjustmentプロパティGet）
- E-14: `Source/CorLib/System.Globalization/HijriCalendar.cls` 行162-169（HijriAdjustmentプロパティLet）
- E-15: `Source/CorLib/System.Globalization/HijriCalendar.cls` 行177-179（Erasプロパティ）
- E-16: `Source/CorLib/System.Globalization/HijriCalendar.cls` 行186-188（TwoDigitYearMaxプロパティGet）
- E-17: `Source/CorLib/System.Globalization/HijriCalendar.cls` 行14-32（MITライセンス）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IObjectインターフェースを実装 | E-03 | ○ |
| C-02 | Calendarインターフェースを実装 | E-03 | ○ |
| C-03 | ICloneableインターフェースを実装 | E-03 | ○ |
| C-04 | DefaultTwoDigitYearMaxは1451 | E-04 | ○ |
| C-05 | エポックはグレゴリオ日227013 | E-05 | ○ |
| C-06 | 30年周期で10631日 | E-06 | ○ |
| C-07 | MaxYearは9666 | E-07 | ○ |
| C-08 | AlgorithmTypeはLunarCalendarを返す | E-08 | ○ |
| C-09 | Clone関数で複製可能 | E-09 | ○ |
| C-10 | IsReadOnlyプロパティを提供 | E-10 | ○ |
| C-11 | MaxSupportedDateTimeは静的プロパティ参照 | E-11 | ○ |
| C-12 | MinSupportedDateTimeは静的プロパティ参照 | E-12 | ○ |
| C-13 | HijriAdjustmentプロパティを提供 | E-13, E-14 | ○ |
| C-14 | HijriAdjustment設定時に-2〜2の範囲チェック | E-14（行165-166） | ○ |
| C-15 | HijriAdjustment設定時にVerifyWritableチェック | E-14（行163） | ○ |
| C-16 | ErasはHijriEra（1）を含む配列を返す | E-15 | ○ |
| C-17 | TwoDigitYearMaxプロパティを提供 | E-16 | ○ |
| C-18 | MITライセンスで提供 | E-17 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 30年周期の閏年判定が正しく実装されているか確認
- [ ] HijriAdjustmentが日付計算に正しく適用されているか確認
- [ ] 表形式（Tabular）イスラム暦の計算が正しいか確認
