---
generated_at: 2026-01-20 16:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：81-KoreanCalendar

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/CorLib/System.Globalization/KoreanCalendar.cls` 38-46行目（クラスドキュメント）
- E-02: `Source/CorLib/System.Globalization/KoreanCalendar.cls` 62-65行目（定数定義）
- E-03: `Source/CorLib/System.Globalization/KoreanCalendar.cls` 620-622行目（GetGregorianYear関数）
- E-04: `Source/CorLib/System.Globalization/KoreanCalendar.cls` 414-416行目（GetYear関数）
- E-05: `Source/CorLib/System.Globalization/KoreanCalendar.cls` 599-617行目（ValidateEra/Year/Month）
- E-06: `Source/CorLib/System.Globalization/KoreanCalendar.cls` 169-171行目（AddDays）
- E-07: `Source/CorLib/System.Globalization/KoreanCalendar.cls` 498-506行目（ToDateTime）
- E-08: `Source/CorLib/System.Globalization/KoreanCalendar.cls` 67-68行目（メンバ変数）
- E-09: `Source/CorLib/System.Globalization/KoreanCalendar.cls` 86-89行目（TwoDigitYearMaxプロパティ）
- E-10: `Source/CorLib/System.Globalization/KoreanCalendarStatic.cls` 57-59行目（KoreanEra定数）
- E-11: `Source/Tests/System.Globalization/KoreanCalendarTests.cls`（テストコード）
- E-12: `docs/code-to-docs/機能一覧/機能一覧.csv` 81行目（機能定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 韓国暦は紀元前2333年を元年とする紀年法 | E-02 (YEAR_OFFSET = 2333) | ○ |
| C-02 | 年オフセットは2333年 | E-02, E-03, E-04 | ○ |
| C-03 | 有効年範囲は2334〜12332 | E-02 (MinKoreanYear=2334, MaxKoreanYear=12332) | ○ |
| C-04 | KoreanEraは常に1を返す | E-10 (KoreanEra = 1) | ○ |
| C-05 | グレゴリオ暦との相互変換機能 | E-03, E-04 | ○ |
| C-06 | 日付演算機能（Add系メソッド） | E-06 | ○ |
| C-07 | ToDateTimeでCorDateTimeを生成 | E-07 | ○ |
| C-08 | ValidateEraでKoreanEra(1)のみ許可 | E-05 (599-606行目) | ○ |
| C-09 | ValidateYearで2334-12332チェック | E-05 (608-612行目) | ○ |
| C-10 | ValidateMonthで1-12チェック | E-05 (614-617行目) | ○ |
| C-11 | TwoDigitYearMaxプロパティ存在 | E-09 | ○ |
| C-12 | IsReadOnlyプロパティ存在 | E-08 (mIsReadOnly変数) | ○ |
| C-13 | ICloneable実装によるClone可能 | E-01 (Implements ICloneable) | ○ |
| C-14 | 機能種別は「韓国暦の日付計算」 | E-12 | ○ |
| C-15 | GetDayOfMonthはCorDateTime.GetDayOfMonthを呼び出す | E-01 (256-258行目) | ○ |
| C-16 | うるう年判定はグレゴリオ暦と同一ルール | E-01 (IsLeapYearメソッド実装) | ○ |
| C-17 | Statics.Calendar.AddXxxを利用 | E-06 | ○ |
| C-18 | PropertyBag対応（シリアライズ） | E-01 (Class_ReadProperties, Class_WriteProperties) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [x] 年オフセット値（2333）がソースコードと一致している
- [x] 有効年範囲（2334-12332）がソースコードと一致している
- [x] KoreanEra定数（1）がソースコードと一致している
- [x] 主要メソッドの行番号が正確である
- [x] データフロー図が実装と一致している
