---
generated_at: 2026-01-20 16:20:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：82-TaiwanCalendar

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/CorLib/System.Globalization/TaiwanCalendar.cls` 38-42行目（クラスドキュメント）
- E-02: `Source/CorLib/System.Globalization/TaiwanCalendar.cls` 49-51行目（定数定義）
- E-03: `Source/CorLib/System.Globalization/TaiwanCalendar.cls` 575-577行目（GetGregorianYear関数）
- E-04: `Source/CorLib/System.Globalization/TaiwanCalendar.cls` 404-406行目（GetYear関数）
- E-05: `Source/CorLib/System.Globalization/TaiwanCalendar.cls` 554-573行目（Validate系メソッド）
- E-06: `Source/CorLib/System.Globalization/TaiwanCalendar.cls` 166-168行目（AddDays）
- E-07: `Source/CorLib/System.Globalization/TaiwanCalendar.cls` 490-497行目（ToDateTime）
- E-08: `Source/CorLib/System.Globalization/TaiwanCalendar.cls` 583-586行目（Class_InitProperties）
- E-09: `Source/CorLib/System.Globalization/TaiwanCalendar.cls` 506-511行目（ToFourDigitYear）
- E-10: `docs/code-to-docs/機能一覧/機能一覧.csv` 82行目（機能定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 台湾暦は1912年を元年とする紀年法 | E-02 (YearOffset = 1911), E-08 (1912, 1, 1) | ○ |
| C-02 | 年オフセットは1911年 | E-02, E-03, E-04 | ○ |
| C-03 | 有効年範囲は1〜8088 | E-02 (MinTaiwanYear=1, MaxTaiwanYear=8088) | ○ |
| C-04 | Era=1のみサポート | E-05 (554-561行目) | ○ |
| C-05 | グレゴリオ暦との相互変換機能 | E-03, E-04 | ○ |
| C-06 | 日付演算機能（Add系メソッド） | E-06 | ○ |
| C-07 | ToDateTimeでCorDateTimeを生成 | E-07 | ○ |
| C-08 | ValidateYearで1-8088チェック | E-05 (563-567行目) | ○ |
| C-09 | ValidateMonthで1-12チェック | E-05 (569-573行目) | ○ |
| C-10 | TwoDigitYearMax初期値はWindowsから取得 | E-08 (CAL_TAIWAN) | ○ |
| C-11 | MinSupportedDateTimeは1912年1月1日 | E-08 (Cor.NewDateTime(1912, 1, 1)) | ○ |
| C-12 | ICloneable実装によるClone可能 | E-01 (Implements ICloneable) | ○ |
| C-13 | 機能種別は「台湾暦の日付計算」 | E-10 | ○ |
| C-14 | ToFourDigitYearは入力値をそのまま返す | E-09 | ○ |
| C-15 | GetDayOfMonthはConvert.ToDateTime.Dayを呼び出す | E-01 (253-255行目) | ○ |
| C-16 | PropertyBag対応（シリアライズ） | E-01 (Class_ReadProperties, Class_WriteProperties) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [x] 年オフセット値（1911）がソースコードと一致している
- [x] 有効年範囲（1-8088）がソースコードと一致している
- [x] MinSupportedDateTime（1912/1/1）がソースコードと一致している
- [x] 主要メソッドの行番号が正確である
- [x] データフロー図が実装と一致している
