---
generated_at: 2026-01-20 16:22:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：83-ThaiBuddhistCalendar

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/CorLib/System.Globalization/ThaiBuddhistCalendar.cls` 38-43行目（クラスドキュメント）
- E-02: `Source/CorLib/System.Globalization/ThaiBuddhistCalendar.cls` 49-51行目（定数定義）
- E-03: `Source/CorLib/System.Globalization/ThaiBuddhistCalendar.cls` 564-566行目（GetGregorianYear関数）
- E-04: `Source/CorLib/System.Globalization/ThaiBuddhistCalendar.cls` 394-396行目（GetYear関数）
- E-05: `Source/CorLib/System.Globalization/ThaiBuddhistCalendar.cls` 543-562行目（Validate系メソッド）
- E-06: `Source/CorLib/System.Globalization/ThaiBuddhistCalendar.cls` 164-166行目（AddDays）
- E-07: `Source/CorLib/System.Globalization/ThaiBuddhistCalendar.cls` 479-485行目（ToDateTime）
- E-08: `Source/CorLib/System.Globalization/ThaiBuddhistCalendar.cls` 572-574行目（Class_InitProperties）
- E-09: `Source/CorLib/System.Globalization/ThaiBuddhistCalendar.cls` 495-500行目（ToFourDigitYear）
- E-10: `docs/code-to-docs/機能一覧/機能一覧.csv` 83行目（機能定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | タイ仏暦はグレゴリオ暦より543年進んだ紀年法 | E-02 (YearOffset = 543) | ○ |
| C-02 | 年オフセットは543年 | E-02, E-03, E-04 | ○ |
| C-03 | 有効年範囲は544〜10542 | E-02 (MinThaiBuddhistYear=544, MaxThaiBuddhistYear=10542) | ○ |
| C-04 | ThaiBuddhistEra(1)のみサポート | E-05 (543-550行目) | ○ |
| C-05 | グレゴリオ暦との相互変換機能 | E-03, E-04 | ○ |
| C-06 | 日付演算機能（Add系メソッド） | E-06 | ○ |
| C-07 | ToDateTimeでCorDateTimeを生成 | E-07 | ○ |
| C-08 | ValidateYearで544-10542チェック | E-05 (552-556行目) | ○ |
| C-09 | ValidateMonthで1-12チェック | E-05 (558-562行目) | ○ |
| C-10 | TwoDigitYearMax初期値はWindowsから取得 | E-08 (CAL_THAI) | ○ |
| C-11 | ICloneable実装によるClone可能 | E-01 (Implements ICloneable) | ○ |
| C-12 | 機能種別は「タイ仏暦の日付計算」 | E-10 | ○ |
| C-13 | GetDayOfMonthはCorDateTime.GetDayOfMonthを呼び出す | E-01 (251-253行目) | ○ |
| C-14 | PropertyBag対応（シリアライズ） | E-01 (Class_ReadProperties, Class_WriteProperties) | ○ |
| C-15 | ToFourDigitYearはStatics.Calendar.ToFourDigitYearを使用 | E-09 | ○ |
| C-16 | GetYearはCorDateTime.GetYear + YearOffset | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [x] 年オフセット値（543）がソースコードと一致している
- [x] 有効年範囲（544-10542）がソースコードと一致している
- [x] 主要メソッドの行番号が正確である
- [x] データフロー図が実装と一致している
- [x] GetYear計算式（+YearOffset）とGetGregorianYear計算式（-YearOffset）が正しい
